/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public class EmptyRevisionHook
extends MetaDataHookAdapter {
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    private List<String> ignoreInDiff = Arrays.asList("revisionnote");

    public EmptyRevisionHook(MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        Map newData;
        boolean eq;
        Map previousData = previous.getData();
        boolean bl = eq = this.mapEquality(previousData, newData = newMetaData.getData()) && this.mapEquality(newData, previousData);
        if (eq) {
            Schema schema = this.metaDataAutoConfiguration.schema(EntityType.RP.getType());
            throw new ValidationException(schema, "No data is changed. An update would result in an empty revision", "empty-revision");
        }
        return super.prePut(previous, newMetaData, user);
    }

    private boolean mapEquality(Map<String, Object> first, Map<String, Object> second) {
        return first.entrySet().stream().allMatch(e -> {
            String firstKey = (String)e.getKey();
            Object firstValue = e.getValue();
            Object secondValue = second.get(firstKey);
            return this.ignoreInDiff.contains(firstKey) || firstValue == null && secondValue == null || firstValue != null && firstValue.equals(secondValue);
        });
    }
}

