/*
 * Decompiled with CFR 0.152.
 */
package manage.web;

import java.util.List;
import manage.api.APIUser;
import manage.api.Scope;
import manage.exception.EndpointNotAllowed;
import manage.model.EntityType;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScopeEnforcer {
    private static final List<EntityType> spEntityTypes = List.of(EntityType.SP, EntityType.RP, EntityType.RS);
    private static final List<EntityType> allEntityTypes = List.of(EntityType.SP, EntityType.RP, EntityType.RS, EntityType.IDP);

    private ScopeEnforcer() {
    }

    public static void enforceWriteScope(APIUser apiUser, EntityType entityType) {
        ScopeEnforcer.enforceScope((EntityType)entityType, (APIUser)apiUser, (Scope)Scope.WRITE_IDP, (Scope)Scope.WRITE_SP, (String)"CRUD");
    }

    public static void enforceChangeRequestScope(APIUser apiUser, EntityType entityType) {
        ScopeEnforcer.enforceScope((EntityType)entityType, (APIUser)apiUser, (Scope)Scope.CHANGE_REQUEST_IDP, (Scope)Scope.CHANGE_REQUEST_SP, (String)"change request");
    }

    private static void enforceScope(EntityType entityType, APIUser apiUser, Scope writeIdp, Scope writeSp, String action) {
        if (entityType.equals((Object)EntityType.IDP) && !apiUser.isAllowed(new Scope[]{writeIdp})) {
            throw new EndpointNotAllowed(String.format("APIUser %s is not allowed to %s for entity %s", apiUser.getName(), action, entityType.getType()));
        }
        if (spEntityTypes.contains(entityType) && !apiUser.isAllowed(new Scope[]{writeSp})) {
            throw new EndpointNotAllowed(String.format("APIUser %s is not allowed to %s for entity %s", apiUser.getName(), action, entityType.getType()));
        }
        if (!allEntityTypes.contains(entityType)) {
            throw new EndpointNotAllowed(String.format("APIUser %s is not allowed to %s for entity %s", apiUser.getName(), action, entityType.getType()));
        }
    }
}

