/*
 * Decompiled with CFR 0.152.
 */
package manage.api;

import java.util.Arrays;
import java.util.List;
import manage.api.AbstractUser;
import manage.api.ImpersonatedUser;
import manage.api.Scope;

public class APIUser
implements AbstractUser {
    private String name;
    private String password;
    private List<Scope> scopes;
    private String environment;
    private boolean isAPIUser = true;
    private ImpersonatedUser impersonatedUser;

    public APIUser(String name, List<Scope> scopes) {
        this.name = name;
        this.scopes = scopes;
    }

    public APIUser(APIUser apiUser) {
        this.name = apiUser.getName();
        this.scopes = apiUser.getScopes();
        this.environment = apiUser.getEnvironment();
    }

    public boolean isAllowed(Scope ... scopes) {
        return this.scopes.containsAll(Arrays.asList(scopes));
    }

    public boolean isSystemUser() {
        return this.scopes.contains(Scope.SYSTEM);
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public boolean isAPIUser() {
        return this.isAPIUser;
    }

    public ImpersonatedUser getImpersonatedUser() {
        return this.impersonatedUser;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setAPIUser(boolean isAPIUser) {
        this.isAPIUser = isAPIUser;
    }

    public void setImpersonatedUser(ImpersonatedUser impersonatedUser) {
        this.impersonatedUser = impersonatedUser;
    }

    public APIUser() {
    }
}

