/*
 * Decompiled with CFR 0.152.
 */
package manage.policies;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import manage.model.MetaData;
import manage.model.Revision;
import manage.policies.CidrNotation;
import manage.policies.LoA;
import manage.policies.PdpAttribute;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PdpPolicyDefinition {
    private String id;
    private String policyId;
    private String name;
    private String description;
    private List<String> serviceProviderIds = new ArrayList();
    private List<String> serviceProviderNames = new ArrayList();
    private List<String> serviceProviderNamesNl = new ArrayList();
    private List<String> identityProviderIds = new ArrayList();
    private List<String> identityProviderNames = new ArrayList();
    private List<String> identityProviderNamesNl = new ArrayList();
    private String clientId;
    private List<PdpAttribute> attributes = new ArrayList();
    private List<LoA> loas = new ArrayList();
    private boolean denyRule;
    private boolean allAttributesMustMatch;
    private Instant created;
    private String userDisplayName;
    private String authenticatingAuthorityName;
    private String denyAdvice;
    private String denyAdviceNl;
    private boolean isActivatedSr;
    private boolean active;
    private boolean actionsAllowed;
    private String type;
    private int revisionNbr;

    public PdpPolicyDefinition(MetaData metaData) {
        this.id = metaData.getId();
        Map data = metaData.getData();
        this.name = (String)data.get("name");
        this.description = (String)data.get("description");
        this.serviceProviderIds = this.convertProviders(data, "serviceProviderIds");
        this.identityProviderIds = this.convertProviders(data, "identityProviderIds");
        this.attributes = ((List)data.getOrDefault("attributes", new ArrayList())).stream().map(m -> new PdpAttribute((String)m.get("name"), (String)m.get("value"), m.getOrDefault("negated", false).booleanValue())).collect(Collectors.toList());
        this.loas = ((List)data.getOrDefault("loas", new ArrayList())).stream().map(m -> {
            List loaAttributes = m.getOrDefault("attributes", new ArrayList());
            return new LoA((String)m.get("level"), m.getOrDefault("allAttributesMustMatch", false).booleanValue(), m.getOrDefault("negateCidrNotation", false).booleanValue(), loaAttributes.stream().map(attr -> new PdpAttribute((String)attr.get("name"), (String)attr.get("value"), attr.getOrDefault("negated", false).booleanValue())).collect(Collectors.toList()), ((List)m.getOrDefault("cidrNotations", new ArrayList())).stream().map(cidr -> new CidrNotation((String)cidr.get("ipAddress"), (Integer)cidr.get("prefix"))).collect(Collectors.toList()));
        }).collect(Collectors.toList());
        this.denyRule = data.getOrDefault("denyRule", false);
        this.allAttributesMustMatch = data.getOrDefault("allAttributesMustMatch", false);
        this.userDisplayName = (String)data.get("userDisplayName");
        this.authenticatingAuthorityName = (String)data.get("authenticatingAuthorityName");
        this.denyAdvice = (String)data.get("denyAdvice");
        this.denyAdviceNl = (String)data.get("denyAdviceNl");
        this.policyId = (String)data.get("policyId");
        this.active = data.getOrDefault("active", false);
        this.type = (String)data.get("type");
        Revision revision = metaData.getRevision();
        this.created = revision.getCreated();
        this.revisionNbr = revision.getNumber();
    }

    private List<String> convertProviders(Map<String, Object> data, String name) {
        return ((List)data.get(name)).stream().map(m -> (String)m.get("name")).collect(Collectors.toList());
    }

    public static void updateProviderStructure(Map<String, Object> data) {
        List.of("identityProviderIds", "serviceProviderIds").forEach(reference -> {
            List names = data.getOrDefault(reference, new ArrayList());
            data.put((String)reference, names.stream().map(name -> new HashMap<String, String>(Map.of("name", name))).collect(Collectors.toList()));
        });
        data.put("metaDataFields", new HashMap());
        List.of("id", "created").forEach(name -> data.remove(name));
    }

    public String getId() {
        return this.id;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getServiceProviderIds() {
        return this.serviceProviderIds;
    }

    public List<String> getServiceProviderNames() {
        return this.serviceProviderNames;
    }

    public List<String> getServiceProviderNamesNl() {
        return this.serviceProviderNamesNl;
    }

    public List<String> getIdentityProviderIds() {
        return this.identityProviderIds;
    }

    public List<String> getIdentityProviderNames() {
        return this.identityProviderNames;
    }

    public List<String> getIdentityProviderNamesNl() {
        return this.identityProviderNamesNl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<PdpAttribute> getAttributes() {
        return this.attributes;
    }

    public List<LoA> getLoas() {
        return this.loas;
    }

    public boolean isDenyRule() {
        return this.denyRule;
    }

    public boolean isAllAttributesMustMatch() {
        return this.allAttributesMustMatch;
    }

    public Instant getCreated() {
        return this.created;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public String getAuthenticatingAuthorityName() {
        return this.authenticatingAuthorityName;
    }

    public String getDenyAdvice() {
        return this.denyAdvice;
    }

    public String getDenyAdviceNl() {
        return this.denyAdviceNl;
    }

    public boolean isActivatedSr() {
        return this.isActivatedSr;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isActionsAllowed() {
        return this.actionsAllowed;
    }

    public String getType() {
        return this.type;
    }

    public int getRevisionNbr() {
        return this.revisionNbr;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setServiceProviderIds(List<String> serviceProviderIds) {
        this.serviceProviderIds = serviceProviderIds;
    }

    public void setServiceProviderNames(List<String> serviceProviderNames) {
        this.serviceProviderNames = serviceProviderNames;
    }

    public void setServiceProviderNamesNl(List<String> serviceProviderNamesNl) {
        this.serviceProviderNamesNl = serviceProviderNamesNl;
    }

    public void setIdentityProviderIds(List<String> identityProviderIds) {
        this.identityProviderIds = identityProviderIds;
    }

    public void setIdentityProviderNames(List<String> identityProviderNames) {
        this.identityProviderNames = identityProviderNames;
    }

    public void setIdentityProviderNamesNl(List<String> identityProviderNamesNl) {
        this.identityProviderNamesNl = identityProviderNamesNl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAttributes(List<PdpAttribute> attributes) {
        this.attributes = attributes;
    }

    public void setLoas(List<LoA> loas) {
        this.loas = loas;
    }

    public void setDenyRule(boolean denyRule) {
        this.denyRule = denyRule;
    }

    public void setAllAttributesMustMatch(boolean allAttributesMustMatch) {
        this.allAttributesMustMatch = allAttributesMustMatch;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public void setAuthenticatingAuthorityName(String authenticatingAuthorityName) {
        this.authenticatingAuthorityName = authenticatingAuthorityName;
    }

    public void setDenyAdvice(String denyAdvice) {
        this.denyAdvice = denyAdvice;
    }

    public void setDenyAdviceNl(String denyAdviceNl) {
        this.denyAdviceNl = denyAdviceNl;
    }

    public void setActivatedSr(boolean isActivatedSr) {
        this.isActivatedSr = isActivatedSr;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setActionsAllowed(boolean actionsAllowed) {
        this.actionsAllowed = actionsAllowed;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRevisionNbr(int revisionNbr) {
        this.revisionNbr = revisionNbr;
    }

    public PdpPolicyDefinition() {
    }
}

