/*
 * Decompiled with CFR 0.152.
 */
package manage.policies;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class PolicyRepository {
    private final JdbcTemplate jdbcTemplate;
    private final RowMapper<Map<String, String>> rowMapper = (rs, rowNum) -> {
        HashMap<String, String> policy = new HashMap<String, String>();
        policy.put("name", rs.getString(1));
        policy.put("xml", rs.getString(2));
        return policy;
    };

    @Autowired
    public PolicyRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<Map<String, String>> policies() {
        return this.jdbcTemplate.query("SELECT name, policy_xml FROM pdp_policies WHERE latest_revision = 1", this.rowMapper);
    }

    public List<Map<String, String>> migratedPolicies() {
        return this.jdbcTemplate.query("SELECT name, policy_xml FROM pdp_migrated_policies", this.rowMapper);
    }
}

