/*
 * Decompiled with CFR 0.152.
 */
package manage.api;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import manage.api.APIUser;
import manage.api.APIUserConfiguration;
import manage.api.ImpersonatedUser;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class APIAuthenticationManager
implements AuthenticationManager {
    public static final String X_IDP_ENTITY_ID = "X-IDP-ENTITY-ID";
    public static final String X_UNSPECIFIED_NAME_ID = "X-UNSPECIFIED-NAME-ID";
    public static final String X_DISPLAY_NAME = "X-DISPLAY-NAME";
    private final APIUserConfiguration apiUserConfiguration;

    public APIAuthenticationManager(APIUserConfiguration apiUserConfiguration) {
        this.apiUserConfiguration = apiUserConfiguration;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String name = (String)String.class.cast(authentication.getPrincipal());
        Optional<APIUser> apiUserOptional = this.apiUserConfiguration.getApiUsers().stream().filter(apiUser -> apiUser.getName().equals(name)).findFirst();
        APIUser apiUser2 = apiUserOptional.orElseThrow(() -> new UsernameNotFoundException("Unknown user: " + name));
        if (!apiUser2.getPassword().equals(authentication.getCredentials())) {
            throw new BadCredentialsException("Bad credentials");
        }
        APIUser principal = new APIUser(apiUser2);
        Optional impersonatedUserOptional = this.impersonatedUser();
        impersonatedUserOptional.ifPresent(arg_0 -> ((APIUser)principal).setImpersonatedUser(arg_0));
        return new UsernamePasswordAuthenticationToken((Object)principal, authentication.getCredentials(), (Collection)apiUser2.getScopes().stream().map(scope -> new SimpleGrantedAuthority("ROLE_".concat(scope.name()))).collect(Collectors.toList()));
    }

    private Optional<ImpersonatedUser> impersonatedUser() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String idpEntityId = request.getHeader(X_IDP_ENTITY_ID);
        String unspecifiedNameId = request.getHeader(X_UNSPECIFIED_NAME_ID);
        String displayName = request.getHeader(X_DISPLAY_NAME);
        if (StringUtils.hasText((String)idpEntityId) && StringUtils.hasText((String)unspecifiedNameId) && StringUtils.hasText((String)displayName)) {
            return Optional.of(new ImpersonatedUser(idpEntityId, unspecifiedNameId, displayName));
        }
        return Optional.empty();
    }
}

