/*
 * Decompiled with CFR 0.152.
 */
package manage.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import manage.conf.MetaDataAutoConfiguration;
import manage.format.MetaDataFeedParser;
import manage.format.SaveURLResource;
import manage.hook.TypeSafetyHook;
import manage.model.EntityType;
import manage.model.Import;
import manage.model.MetaData;
import manage.service.ExporterService;
import org.apache.commons.io.IOUtils;
import org.everit.json.schema.ValidationException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class ImporterService {
    public static final String META_DATA_FIELDS = "metaDataFields";
    public static final String ARP = "arp";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    private MetaDataFeedParser metaDataFeedParser;
    private Environment environment;
    private TypeSafetyHook metaDataHook;
    private String autoRefreshUserAgent;

    public ImporterService(MetaDataAutoConfiguration metaDataAutoConfiguration, Environment environment, @Value(value="${product.supported_languages}") String supportedLanguages, @Value(value="${metadata_import.useragent:OpenConext-Manage}") String autoRefreshUserAgent) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.environment = environment;
        this.metaDataHook = new TypeSafetyHook(metaDataAutoConfiguration);
        this.metaDataFeedParser = new MetaDataFeedParser(Stream.of(supportedLanguages.split(",")).map(String::trim).collect(Collectors.toList()));
        this.autoRefreshUserAgent = autoRefreshUserAgent;
    }

    public Map<String, Object> importXMLUrl(EntityType type, Import importRequest) {
        try {
            SaveURLResource resource = new SaveURLResource(new URL(importRequest.getUrl()), this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})), this.autoRefreshUserAgent);
            Map result = this.importXML((Resource)resource, type, Optional.ofNullable(importRequest.getEntityId()));
            if (result.isEmpty()) {
                return Collections.singletonMap("errors", Collections.singletonList("URL did not contain valid SAML metadata"));
            }
            result.put("metadataurl", importRequest.getUrl());
            return result;
        }
        catch (IOException | XMLStreamException e) {
            return Collections.singletonMap("errors", Collections.singletonList(e.getClass().getName()));
        }
    }

    public Map<String, Object> importXML(Resource resource, EntityType entityType, Optional<String> entityId) throws IOException, XMLStreamException {
        return this.metaDataFeedParser.importXML(resource, entityType, entityId, this.metaDataAutoConfiguration);
    }

    public List<Map<String, Object>> importFeed(Resource resource) throws IOException, XMLStreamException {
        return this.metaDataFeedParser.importFeed(resource, this.metaDataAutoConfiguration);
    }

    public Map<String, Object> importJson(String type, Map<String, Object> json) throws JsonProcessingException {
        EntityType entityType = this.getType(type, json);
        try {
            return this.importJSON(entityType, json);
        }
        catch (ValidationException e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("errors", e.getAllMessages());
            result.put("type", entityType.getType());
            return result;
        }
    }

    public Map<String, Object> importJsonUrl(String type, Import importRequest) {
        try {
            SaveURLResource resource = new SaveURLResource(new URL(importRequest.getUrl()), this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})), this.autoRefreshUserAgent);
            String json = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
            Map map = (Map)this.objectMapper.readValue(json, Map.class);
            return this.importJson(type, map);
        }
        catch (IOException e) {
            return Collections.singletonMap("errors", Collections.singletonList(e.getClass().getName()));
        }
    }

    public Map<String, Object> importJSON(EntityType entityType, Map<String, Object> data) throws JsonProcessingException {
        data.entrySet().removeIf(entry -> entry.getValue() == null);
        ConcurrentHashMap<String, Object> json = new ConcurrentHashMap<String, Object>(data);
        Object metaDataFieldsMap = json.get(META_DATA_FIELDS);
        if (!(metaDataFieldsMap instanceof Map)) {
            this.metaDataAutoConfiguration.validate(json, entityType.getType());
            return Collections.EMPTY_MAP;
        }
        ConcurrentHashMap metaDataFields = new ConcurrentHashMap((Map)metaDataFieldsMap);
        json.put(META_DATA_FIELDS, metaDataFields);
        if (!entityType.equals((Object)EntityType.IDP) && json.containsKey("disableConsent")) {
            json.remove("disableConsent");
        }
        if (!entityType.equals((Object)EntityType.IDP) && json.containsKey("stepupEntities")) {
            json.remove("stepupEntities");
        }
        if (!entityType.equals((Object)EntityType.IDP) && json.containsKey("mfaEntities")) {
            json.remove("mfaEntities");
        }
        if (!entityType.equals((Object)EntityType.RP) && json.containsKey("allowedResourceServers")) {
            json.remove("allowedResourceServers");
        }
        if (metaDataFields.values().stream().anyMatch(value -> value instanceof Map)) {
            if (json.containsKey("allowedEntities")) {
                List allowedEntities = (List)json.get("allowedEntities");
                json.put("allowedEntities", allowedEntities.stream().map(name -> Collections.singletonMap("name", name)).collect(Collectors.toList()));
            }
            if (json.containsKey("disableConsent")) {
                List disableConsent = (List)json.get("disableConsent");
                json.put("disableConsent", disableConsent.stream().map(name -> Collections.singletonMap("name", name)).collect(Collectors.toList()));
            }
            if (json.containsKey("stepupEntities")) {
                List stepupEntities = (List)json.get("stepupEntities");
                json.put("stepupEntities", stepupEntities.stream().map(name -> Collections.singletonMap("name", name)).collect(Collectors.toList()));
            }
            if (json.containsKey("mfaEntities")) {
                List mfaEntities = (List)json.get("mfaEntities");
                json.put("mfaEntities", mfaEntities.stream().map(name -> Collections.singletonMap("name", name)).collect(Collectors.toList()));
            }
            ConcurrentHashMap flattened = new ConcurrentHashMap();
            metaDataFields.entrySet().forEach(entry -> {
                Object value = entry.getValue();
                if (value instanceof String) {
                    flattened.put((String)entry.getKey(), value);
                }
                if (value instanceof Map) {
                    String keyPrefix = (String)entry.getKey();
                    this.flatten(keyPrefix, (Map)value, flattened);
                }
            });
            json.put(META_DATA_FIELDS, flattened);
        }
        ExporterService.excludedDataFields.forEach(json::remove);
        MetaData metaData = this.metaDataHook.preValidate(new MetaData(entityType.getType(), json));
        Map migratedData = metaData.getData();
        this.metaDataAutoConfiguration.validate(migratedData, entityType.getType());
        return new TreeMap<String, Object>(migratedData);
    }

    private void flatten(String keyPrefix, Map<String, Object> value, Map<String, Object> target) {
        value.forEach((key, entryValue) -> {
            if (entryValue instanceof String) {
                target.put(keyPrefix + ":" + key, entryValue);
            }
            if (entryValue instanceof Map) {
                this.flatten(keyPrefix + ":" + key, (Map)entryValue, target);
            }
        });
    }

    private EntityType getType(String type, Map<String, Object> json) {
        EntityType entityType;
        Object object = EntityType.IDP.getType().equals(type) ? EntityType.IDP : (entityType = EntityType.SP.getType().equals(type) ? EntityType.SP : null);
        if (entityType == null) {
            Object jsonType = json.get("type");
            if (jsonType == null) {
                throw new IllegalArgumentException("Expected a 'type' attribute in the JSON with value 'saml20-idp' or 'saml20-sp'");
            }
            return EntityType.fromType((String)((String)jsonType));
        }
        return entityType;
    }
}

