/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manage.format.EngineBlockFormatter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.model.PushOptions;
import manage.model.Scope;
import manage.policies.PdpPolicyDefinition;
import manage.repository.MetaDataRepository;
import manage.web.HttpHostProvider;
import manage.web.PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@Component
@RestController
public class DatabaseController {
    private final RestTemplate restTemplate;
    private final String pushUri;
    private final RestTemplate oidcRestTemplate;
    private final String oidcPushUri;
    private final boolean oidcEnabled;
    private final boolean excludeEduGainImported;
    private final boolean excludeOidcRP;
    private final boolean excludeSRAM;
    private final MetaDataRepository metaDataRepository;
    private final Environment environment;
    private final String pdpPushUri;
    private final RestTemplate pdpRestTemplate;
    private final boolean pdpEnabled;

    @Autowired
    DatabaseController(MetaDataRepository metaDataRepository, @Value(value="${push.eb.url}") String pushUri, @Value(value="${push.eb.user}") String user, @Value(value="${push.eb.password}") String password, @Value(value="${push.eb.exclude_edugain_imports}") boolean excludeEduGainImported, @Value(value="${push.eb.exclude_oidc_rp}") boolean excludeOidcRP, @Value(value="${push.eb.exclude_sram}") boolean excludeSRAM, @Value(value="${push.oidc.url}") String oidcPushUri, @Value(value="${push.oidc.user}") String oidcUser, @Value(value="${push.oidc.password}") String oidcPassword, @Value(value="${push.pdp.url}") String pdpPushUri, @Value(value="${push.pdp.user}") String pdpUser, @Value(value="${push.pdp.password}") String pdpPassword, @Value(value="${push.pdp.enabled}") boolean pdpEnabled, @Value(value="${push.oidc.enabled}") boolean oidcEnabled, Environment environment) throws MalformedURLException {
        this.metaDataRepository = metaDataRepository;
        this.pushUri = pushUri;
        this.restTemplate = new RestTemplate(this.getRequestFactory(user, password, pushUri));
        this.excludeEduGainImported = excludeEduGainImported;
        this.excludeOidcRP = excludeOidcRP;
        this.excludeSRAM = excludeSRAM;
        this.oidcRestTemplate = oidcEnabled ? new RestTemplate(this.getRequestFactory(oidcUser, oidcPassword, oidcPushUri)) : null;
        this.oidcPushUri = oidcPushUri;
        this.oidcEnabled = oidcEnabled;
        this.pdpRestTemplate = pdpEnabled ? new RestTemplate(this.getRequestFactory(pdpUser, pdpPassword, pdpPushUri)) : null;
        this.pdpPushUri = pdpPushUri;
        this.pdpEnabled = pdpEnabled;
        this.environment = environment;
    }

    public ResponseEntity<Map> doPush(PushOptions pushOptions) {
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}))) {
            return new ResponseEntity(Collections.singletonMap("status", "OK"), HttpStatus.OK);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (pushOptions.isIncludePdP() && this.pdpEnabled) {
            List policies = this.metaDataRepository.findAllByType(EntityType.PDP.getType()).stream().map(metaData -> new PdpPolicyDefinition(metaData)).filter(policyDefinition -> policyDefinition.isActive()).collect(Collectors.toList());
            this.pdpRestTemplate.put(this.pdpPushUri, policies, new Object[0]);
            result.put("status", "OK");
            result.put("pdp", true);
        }
        if (pushOptions.isIncludeEB()) {
            Map json = this.pushPreview();
            ResponseEntity response = this.restTemplate.postForEntity(this.pushUri, (Object)json, String.class, new Object[0]);
            result.put("status", "OK");
            result.put("response", response);
        }
        if (!this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})) && this.oidcEnabled && pushOptions.isIncludeOIDC()) {
            List relyingParties = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.RP.getType());
            List resourceServers = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.RS.getType());
            List scopes = this.metaDataRepository.getMongoTemplate().findAll(Scope.class);
            Map<String, Scope> scopesMapped = scopes.stream().collect(Collectors.toMap(Scope::getName, scope -> scope));
            resourceServers.forEach(rs -> {
                rs.setType(EntityType.RP.getType());
                Map metaDataFields = rs.metaDataFields();
                metaDataFields.put("isResourceServer", true);
                List scopeList = (List)metaDataFields.get("scopes");
                if (!CollectionUtils.isEmpty((Collection)scopeList)) {
                    List transformedScope = scopeList.stream().map(scope -> scopesMapped.getOrDefault(scope, null)).filter(Objects::nonNull).collect(Collectors.toList());
                    metaDataFields.put("scopes", transformedScope);
                }
            });
            if (!this.excludeSRAM) {
                List sramRelyingParties = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.SRAM.getType()).stream().filter(sramRP -> "oidc_rp".equals(sramRP.metaDataFields().get("connection_type"))).collect(Collectors.toList());
                relyingParties.addAll(sramRelyingParties);
            }
            relyingParties.forEach(rp -> {
                Map metaDataFields = rp.metaDataFields();
                metaDataFields.put("isResourceServer", false);
                metaDataFields.remove("scopes");
            });
            relyingParties.addAll(resourceServers);
            List filteredEntities = relyingParties.stream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toList());
            this.oidcRestTemplate.postForEntity(this.oidcPushUri, filteredEntities, Void.class, new Object[0]);
            result.put("oidc", true);
            result.put("status", "OK");
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/pushPreview"})
    public Map<String, Map<String, Map<String, Object>>> pushPreview() {
        EngineBlockFormatter formatter = new EngineBlockFormatter();
        List serviceProviders = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.SP.getType());
        Stream metaDataStream = this.excludeEduGainImported ? serviceProviders.stream().filter(metaData -> {
            Map metaDataFields = metaData.metaDataFields();
            boolean importedFromEdugain = Boolean.TRUE.equals(metaDataFields.get("coin:imported_from_edugain"));
            boolean pushEnabled = Boolean.TRUE.equals(metaDataFields.get("coin:push_enabled"));
            return !importedFromEdugain || pushEnabled;
        }) : serviceProviders.stream();
        Map<String, Map> serviceProvidersToPush = metaDataStream.filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseServiceProvider(arg_0)));
        List identityProviders = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.IDP.getType());
        this.filterOutNullDisableConsentExplanations(identityProviders);
        Map<String, Map> identityProvidersToPush = identityProviders.stream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseIdentityProvider(arg_0)));
        if (!this.excludeOidcRP) {
            List relyingParties = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.RP.getType());
            Map<String, Map> oidcClientsToPush = relyingParties.stream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseOidcClient(arg_0)));
            serviceProvidersToPush.putAll(oidcClientsToPush);
        }
        if (!this.excludeSRAM) {
            List sramServices = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.SRAM.getType());
            Map<String, Map> sramServicesToProvidersToPush = sramServices.stream().collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseServiceProvider(arg_0)));
            serviceProvidersToPush.putAll(sramServicesToProvidersToPush);
        }
        serviceProvidersToPush.putAll(identityProvidersToPush);
        HashMap<String, Map<String, Map<String, Object>>> results = new HashMap<String, Map<String, Map<String, Object>>>();
        results.put("connections", serviceProvidersToPush);
        return results;
    }

    private boolean excludeFromPush(Map metaDataFields) {
        Boolean excludeFromPush = metaDataFields.getOrDefault("coin:exclude_from_push", false);
        if (excludeFromPush instanceof String) {
            return "1".equals(excludeFromPush);
        }
        return excludeFromPush;
    }

    public void filterOutNullDisableConsentExplanations(List<MetaData> identityProviders) {
        identityProviders.forEach(idp -> {
            Object disableConsentData = idp.getData().get("disableConsent");
            if (disableConsentData instanceof List) {
                List disableConsent = (List)disableConsentData;
                disableConsent.forEach(disableConsentEntry -> {
                    if (disableConsentEntry instanceof Map) {
                        Map disableConsentMap = (Map)disableConsentEntry;
                        disableConsentMap.entrySet().removeIf(entry -> entry.getValue() == null);
                    }
                });
            }
        });
    }

    private ClientHttpRequestFactory getRequestFactory(String user, String password, String uri) throws MalformedURLException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().evictExpiredConnections().evictIdleConnections(10L, TimeUnit.SECONDS);
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        Optional optionalHttpHost = HttpHostProvider.resolveHttpHost((URL)new URL(uri));
        optionalHttpHost.ifPresent(httpHost -> httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(httpHost)));
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return new PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory((HttpClient)httpClient, uri);
    }
}

