/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import manage.model.EntityType;
import manage.model.Import;
import manage.model.XML;
import manage.service.ImporterService;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ImportController {
    private ImporterService importerService;

    public ImportController(ImporterService importerService) {
        this.importerService = importerService;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/endpoint/xml/{type}"})
    public Map<String, Object> importXMLUrl(@PathVariable(value="type") String type, @Validated @RequestBody Import importRequest) {
        return this.importerService.importXMLUrl(EntityType.fromType((String)type), importRequest);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/xml/{type}"})
    public Map<String, Object> importXml(@PathVariable(value="type") String type, @Validated @RequestBody XML container) {
        try {
            return this.importerService.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.fromType((String)type), Optional.ofNullable(container.getEntityId()));
        }
        catch (IOException | XMLStreamException e) {
            return Collections.singletonMap("errors", Collections.singletonList(e.getClass().getName()));
        }
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/json/{type}"})
    public Map<String, Object> importJson(@PathVariable(value="type") String type, @RequestBody Map<String, Object> json) throws IOException {
        return this.importerService.importJson(type, json);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/endpoint/json/{type}"})
    public Map<String, Object> importJsonUrl(@PathVariable(value="type") String type, @Validated @RequestBody Import importRequest) {
        return this.importerService.importJsonUrl(type, importRequest);
    }
}

