/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import manage.api.APIUser;
import manage.api.AbstractUser;
import manage.api.Scope;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.policies.PdpPolicyDefinition;
import manage.policies.PolicyRepository;
import manage.policies.PolicySummary;
import manage.repository.MetaDataRepository;
import manage.service.MetaDataService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;

@RestController
public class PdPController {
    private final PolicyRepository policyRepository;
    private final String policyUrl;
    private final String decideUrl;
    private final RestTemplate pdpRestTemplate;
    private final ObjectMapper objectMapper;
    private final MetaDataService metaDataService;
    private final MetaDataRepository metaDataRepository;
    private final HttpHeaders headers;
    private final Pattern descriptionPattern = Pattern.compile("<Description>(.+?)</Description>", 32);

    public PdPController(PolicyRepository policyRepository, @Value(value="${push.pdp.policy_url}") String policyUrl, @Value(value="${push.pdp.decide_url}") String decideUrl, @Value(value="${push.pdp.user}") String pdpUser, @Value(value="${push.pdp.password}") String pdpPassword, ObjectMapper objectMapper, MetaDataService metaDataService, MetaDataRepository metaDataRepository) {
        this.policyRepository = policyRepository;
        this.policyUrl = policyUrl;
        this.decideUrl = decideUrl;
        this.objectMapper = objectMapper;
        this.metaDataService = metaDataService;
        this.metaDataRepository = metaDataRepository;
        this.pdpRestTemplate = new RestTemplate();
        this.pdpRestTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(pdpUser, pdpPassword));
        this.headers = new HttpHeaders();
        this.headers.add("Content-Type", "application/json");
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/pdp/push_analysis"})
    public Map<String, Object> pushAnalysis() {
        List policies = this.policyRepository.policies();
        List migratedPolicies = this.policyRepository.migratedPolicies();
        List missingPolicies = policies.stream().filter(policy -> policy.isActive() && migratedPolicies.stream().noneMatch(migratedPolicy -> this.nameEquality(policy, migratedPolicy))).collect(Collectors.toList());
        this.addDescription(missingPolicies);
        List differences = migratedPolicies.stream().map(migratedPolicy -> policies.stream().filter(policy -> this.nameEquality(policy, migratedPolicy)).findFirst().map(policy -> Map.of(policy.getName(), DiffBuilder.compare((Object)Input.fromString((String)policy.getXml())).withTest((Object)Input.fromString((String)migratedPolicy.getXml())).ignoreWhitespace().normalizeWhitespace().ignoreElementContentWhitespace().build().toString()))).filter(optionalMap -> optionalMap.isPresent()).map(optionalMap -> (Map)optionalMap.get()).filter(map -> !map.containsValue("[identical]")).collect(Collectors.toList());
        return Map.of("policy_count", policies.size(), "active_policy_count", policies.stream().filter(policy -> policy.isActive()).count(), "migrated_policy_count", migratedPolicies.size(), "missing_policies", missingPolicies, "differences", differences);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/pdp/policies"})
    public List<PolicySummary> policies() {
        List policies = this.policyRepository.policies();
        this.addDescription(policies);
        return policies;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/pdp/migrated_policies"})
    public List<PolicySummary> migratedPolicies() {
        List policies = this.policyRepository.migratedPolicies();
        this.addDescription(policies);
        return policies;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/pdp/decide"})
    public String decideManage(@RequestBody String payload) {
        HttpEntity requestEntity = new HttpEntity((Object)payload, (MultiValueMap)this.headers);
        return (String)this.pdpRestTemplate.exchange(this.decideUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]).getBody();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/pdp/missing-enforcements"})
    public List<MetaData> policiesWithMissingPolicyEnforcementDecisionRequired() {
        return this.metaDataRepository.policiesWithMissingPolicyEnforcementDecisionRequired();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/pdp/import_policies"})
    public Map<String, List<Object>> importPolicies() throws JsonProcessingException {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.headers);
        List policyDefinitions = (List)this.pdpRestTemplate.exchange(this.policyUrl, HttpMethod.GET, requestEntity, List.class, new Object[0]).getBody();
        String json = this.objectMapper.writeValueAsString((Object)policyDefinitions);
        List dataList = (List)this.objectMapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.metaDataService.deleteCollection(EntityType.PDP);
        Map<String, List<Object>> results = Map.of("imported", new ArrayList(), "errors", new ArrayList());
        dataList.forEach(data -> {
            PdpPolicyDefinition.updateProviderStructure((Map)data);
            MetaData metaData = new MetaData(EntityType.PDP.getType(), data);
            Map missingReferences = this.missingReferences(metaData);
            if (missingReferences.values().stream().anyMatch(references -> !references.isEmpty())) {
                ((List)results.get("errors")).add(Map.of("name", metaData.getData().get("name"), "error", "Unknown providers: " + String.valueOf(missingReferences.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toList()))));
            } else {
                try {
                    MetaData savedMetaData = this.metaDataService.doPost(metaData, (AbstractUser)new APIUser("PDP import", List.of(Scope.SYSTEM)), false);
                    ((List)results.get("imported")).add(savedMetaData);
                }
                catch (RuntimeException e2) {
                    ((List)results.get("errors")).add(Map.of("name", metaData.getData().get("name"), "error", e2.getMessage()));
                }
            }
        });
        return results;
    }

    private void addDescription(List<PolicySummary> policies) {
        policies.forEach(policy -> {
            Matcher matcher = this.descriptionPattern.matcher(policy.getXml());
            matcher.find();
            policy.setDescription(matcher.group(1));
        });
    }

    private Map<String, List<String>> missingReferences(MetaData newMetaData) {
        String serviceProviderIds = "serviceProviderIds";
        String identityProviderIds = "identityProviderIds";
        Map<String, List<EntityType>> relationsToCheck = Map.of(serviceProviderIds, Arrays.asList(EntityType.SP, EntityType.RP), identityProviderIds, Collections.singletonList(EntityType.IDP));
        Map<String, List<String>> missingReferences = Map.of(serviceProviderIds, new ArrayList(), identityProviderIds, new ArrayList());
        relationsToCheck.forEach((key, value) -> {
            List references;
            if (newMetaData.getData().containsKey(key) && !CollectionUtils.isEmpty((Collection)(references = (List)newMetaData.getData().get(key)))) {
                List missingProviders = references.stream().filter(map -> value.stream().allMatch(entityType -> CollectionUtils.isEmpty((Collection)this.metaDataRepository.findRaw(entityType.getType(), String.format("{\"data.entityid\" : \"%s\"}", map.get("name")))))).map(m -> (String)m.get("name")).collect(Collectors.toList());
                ((List)missingReferences.get(key)).addAll(missingProviders);
            }
        });
        return missingReferences;
    }

    private boolean nameEquality(PolicySummary policy, PolicySummary otherPolicy) {
        return policy.getName().trim().equals(otherPolicy.getName().trim());
    }
}

