/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.Map;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.shibboleth.FederatedUser;

public class ExtraneousKeysPoliciesHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;

    public ExtraneousKeysPoliciesHook(MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.PDP.getType());
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        this.removeExtraneousKeys(newMetaData, user);
        return super.prePut(previous, newMetaData, user);
    }

    public MetaData prePost(MetaData metaData, AbstractUser user) {
        this.removeExtraneousKeys(metaData, user);
        return super.prePost(metaData, user);
    }

    private void removeExtraneousKeys(MetaData newMetaData, AbstractUser user) {
        Map data = newMetaData.getData();
        Map schemaRepresentation = this.metaDataAutoConfiguration.schemaRepresentation(EntityType.PDP);
        Map schemaProperties = (Map)schemaRepresentation.get("properties");
        data.keySet().removeIf(key -> !schemaProperties.containsKey(key));
        String name = (String)data.get("name");
        data.put("entityid", name);
        data.put("policyId", "urn:surfconext:xacml:policy:id:" + name.replaceAll("\\W+", "_").toLowerCase());
        data.computeIfAbsent("authenticatingAuthorityName", k -> user instanceof FederatedUser ? ((FederatedUser)user).getSchacHomeOrganization() : "api");
        data.computeIfAbsent("userDisplayName", k -> user.getName());
    }
}

