/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.springframework.util.StringUtils;

public class ProvisioningHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;
    private final MetaDataRepository metaDataRepository;

    public ProvisioningHook(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.PROV.getType());
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        String newProvisioningType;
        String previousProvisioningType = (String)previous.metaDataFields().get("provisioning_type");
        if (!previousProvisioningType.equals(newProvisioningType = (String)newMetaData.metaDataFields().get("provisioning_type"))) {
            Schema schema = this.metaDataAutoConfiguration.schema(EntityType.PROV.getType());
            throw new ValidationException(schema, String.format("Not allowed the change the provisioning_type for provisioning metadata (changed from %s to %s). Delete this entity and create new provisioning", previousProvisioningType, newProvisioningType), "metaDataFields.provisioning_type");
        }
        this.prePost(newMetaData, user);
        return this.filterInvalidApplications(newMetaData);
    }

    public MetaData prePost(MetaData metaData, AbstractUser user) {
        this.validate(metaData);
        this.validateScimIdentifier(metaData);
        return this.filterInvalidApplications(metaData);
    }

    private void validate(MetaData newMetaData) {
        Map metaDataFields = newMetaData.metaDataFields();
        ArrayList failures = new ArrayList();
        Schema schema = this.metaDataAutoConfiguration.schema(EntityType.PROV.getType());
        String provisioningType = (String)metaDataFields.get("provisioning_type");
        Map.of("scim", List.of("scim_url", "scim_user", "scim_password"), "graph", List.of("graph_client_id", "graph_secret", "graph_tenant"), "eva", List.of("eva_url", "eva_token")).forEach((type, required) -> {
            if (type.equals(provisioningType)) {
                required.forEach(attribute -> {
                    if (!StringUtils.hasText((String)((String)metaDataFields.get(attribute)))) {
                        failures.add(new ValidationException(schema, String.format("%s is required with provisioningType %s", attribute, provisioningType), attribute));
                    }
                });
            }
        });
        ValidationException.throwFor((Schema)schema, failures);
    }

    private MetaData filterInvalidApplications(MetaData metaData) {
        List applications = metaData.getData().getOrDefault("applications", Collections.emptyList());
        List newApplications = applications.stream().filter(application -> this.metaDataRepository.findById((String)application.get("id"), (String)application.get("type")) != null).collect(Collectors.toList());
        metaData.getData().put("applications", newApplications);
        return metaData;
    }

    private void validateScimIdentifier(MetaData newMetaData) {
        Map metaDataFields = newMetaData.metaDataFields();
        String provisioningType = (String)metaDataFields.get("provisioning_type");
        String scimUserIdentifier = (String)metaDataFields.get("scim_user_identifier");
        if ("scim".equals(provisioningType) && "eduID".equals(scimUserIdentifier)) {
            String institutionGuid = (String)metaDataFields.get("coin:institution_guid");
            if (!StringUtils.hasText((String)institutionGuid)) {
                Schema schema = this.metaDataAutoConfiguration.schema(EntityType.PROV.getType());
                throw new ValidationException(schema, "coin:institution_guid is required, for scim provisioning with an eduID scim_user_identifier.");
            }
            List references = this.metaDataRepository.findRaw(EntityType.IDP.getType(), String.format("{\"data.metaDataFields.coin:institution_guid\" : \"%s\"}", institutionGuid));
            if (references.isEmpty()) {
                Schema schema = this.metaDataAutoConfiguration.schema(EntityType.PROV.getType());
                throw new ValidationException(schema, "coin:institution_guid must be a valid / existing IdP institution_guid.");
            }
        }
    }
}

