/*
 * Decompiled with CFR 0.152.
 */
package manage.policies;

import java.util.List;
import manage.policies.PolicySummary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class PolicyRepository {
    private final JdbcTemplate jdbcTemplate;
    private final RowMapper<PolicySummary> rowMapper = (rs, rowNum) -> new PolicySummary(rs.getString(1), rs.getString(2), rs.getBoolean(3));

    @Autowired
    public PolicyRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<PolicySummary> policies() {
        return this.jdbcTemplate.query("SELECT name, policy_xml, is_active FROM pdp_policies WHERE latest_revision = 1", this.rowMapper);
    }

    public List<PolicySummary> migratedPolicies() {
        return this.jdbcTemplate.query("SELECT name, policy_xml, is_active FROM pdp_migrated_policies", this.rowMapper);
    }
}

