/*
 * Decompiled with CFR 0.152.
 */
package manage.model;

import java.util.HashMap;
import java.util.Map;

public class ServiceProvider {
    private String id;
    private String entityId;
    private boolean importedFromEduGain;
    private boolean publishedInEduGain;
    private String name;

    public ServiceProvider(Map map) {
        this.id = (String)map.get("_id");
        Map data = map.getOrDefault("data", new HashMap());
        this.entityId = (String)data.get("entityid");
        Map metaDataFields = data.getOrDefault("metaDataFields", new HashMap());
        this.name = (String)metaDataFields.get("name:en");
        this.importedFromEduGain = this.parseBoolean(metaDataFields.get("coin:imported_from_edugain"));
        this.publishedInEduGain = this.parseBoolean(metaDataFields.get("coin:publish_in_edugain"));
    }

    private boolean parseBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return "1".equals(o);
        }
        if (o instanceof Boolean) {
            return (Boolean)Boolean.class.cast(o);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public boolean isImportedFromEduGain() {
        return this.importedFromEduGain;
    }

    public boolean isPublishedInEduGain() {
        return this.publishedInEduGain;
    }

    public String getName() {
        return this.name;
    }

    public ServiceProvider(String id, String entityId, boolean importedFromEduGain, boolean publishedInEduGain, String name) {
        this.id = id;
        this.entityId = entityId;
        this.importedFromEduGain = importedFromEduGain;
        this.publishedInEduGain = publishedInEduGain;
        this.name = name;
    }
}

