/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.util.List;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class PdPController {
    private final String decideUrl;
    private final RestTemplate pdpRestTemplate;
    private final MetaDataRepository metaDataRepository;
    private final HttpHeaders headers;

    public PdPController(@Value(value="${push.pdp.decide_url}") String decideUrl, @Value(value="${push.pdp.user}") String pdpUser, @Value(value="${push.pdp.password}") String pdpPassword, MetaDataRepository metaDataRepository) {
        this.decideUrl = decideUrl;
        this.metaDataRepository = metaDataRepository;
        this.pdpRestTemplate = new RestTemplate();
        this.pdpRestTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(pdpUser, pdpPassword));
        this.headers = new HttpHeaders();
        this.headers.add("Content-Type", "application/json");
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/pdp/decide"})
    public String decideManage(@RequestBody String payload) {
        HttpEntity requestEntity = new HttpEntity((Object)payload, (MultiValueMap)this.headers);
        return (String)this.pdpRestTemplate.exchange(this.decideUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]).getBody();
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @GetMapping(value={"/client/pdp/missing-enforcements", "/internal/pdp/missing-enforcements"})
    public List<MetaData> policiesWithMissingPolicyEnforcementDecisionRequired() {
        return this.metaDataRepository.policiesWithMissingPolicyEnforcementDecisionRequired();
    }
}

