/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mongodb.client.result.DeleteResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import manage.api.APIUser;
import manage.api.AbstractUser;
import manage.api.Scope;
import manage.conf.MetaDataAutoConfiguration;
import manage.model.ChangeRequest;
import manage.model.EntityType;
import manage.model.Import;
import manage.model.MetaData;
import manage.model.MetaDataChangeRequest;
import manage.model.MetaDataKeyDelete;
import manage.model.MetaDataUpdate;
import manage.model.PathUpdates;
import manage.model.RevisionRestore;
import manage.model.StatsEntry;
import manage.model.XML;
import manage.repository.MetaDataRepository;
import manage.service.ExporterService;
import manage.service.ImporterService;
import manage.service.MetaDataService;
import manage.shibboleth.FederatedUser;
import manage.web.ScopeEnforcer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetaDataController {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataController.class);
    private final MetaDataRepository metaDataRepository;
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;
    private final MetaDataService metaDataService;
    private final ExporterService exporterService;
    private final ImporterService importerService;

    public MetaDataController(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration, ExporterService exporterService, ImporterService importerService, MetaDataService metaDataService) {
        this.metaDataRepository = metaDataRepository;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.exporterService = exporterService;
        this.importerService = importerService;
        this.metaDataService = metaDataService;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/template/{type}"})
    public MetaData template(@PathVariable(value="type") String type) {
        Map data = this.metaDataAutoConfiguration.metaDataTemplate(type);
        return new MetaData(type, data);
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @GetMapping(value={"/client/metadata/{type}/{id}", "/internal/metadata/{type}/{id}"})
    public MetaData get(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return this.metaDataService.getMetaDataAndValidate(type, id);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/metadata/configuration"})
    public List<Map<String, Object>> configuration() {
        return this.metaDataAutoConfiguration.schemaRepresentations();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/metadata"})
    public MetaData post(@Validated @RequestBody MetaData metaData, FederatedUser federatedUser) throws JsonProcessingException {
        return this.metaDataService.doPost(metaData, (AbstractUser)federatedUser, false);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/includeInPush/{type}/{id}"})
    public MetaData includeInPush(@PathVariable(value="type") String type, @PathVariable(value="id") String id, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData metaData = this.get(type, id);
        Map metaDataFields = metaData.metaDataFields();
        metaDataFields.remove("coin:exclude_from_push");
        return this.metaDataService.doPut(metaData, (AbstractUser)federatedUser, false);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/metadata/stats"})
    public List<StatsEntry> stats(FederatedUser user) {
        return this.metaDataRepository.stats();
    }

    @PreAuthorize(value="hasAnyRole('WRITE_SP', 'WRITE_IDP', 'SYSTEM')")
    @PostMapping(value={"/internal/metadata"})
    public MetaData postInternal(@Validated @RequestBody MetaData metaData, APIUser apiUser) {
        ScopeEnforcer.enforceWriteScope((APIUser)apiUser, (EntityType)EntityType.fromType((String)metaData.getType()));
        return this.metaDataService.doPost(metaData, (AbstractUser)apiUser, !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('WRITE_SP')")
    @PostMapping(value={"/internal/new-sp"})
    public MetaData newSP(@Validated @RequestBody XML container, APIUser apiUser) throws IOException, XMLStreamException {
        Map innerJson = this.importerService.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.SP, Optional.empty());
        this.metaDataService.addDefaultSpData(innerJson);
        MetaData metaData = new MetaData(EntityType.SP.getType(), innerJson);
        return this.metaDataService.doPost(metaData, (AbstractUser)apiUser, !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"/client/delete/feed"})
    public Map<String, Long> deleteFeed() {
        long deleted = this.metaDataRepository.deleteAllImportedServiceProviders();
        return Collections.singletonMap("deleted", deleted);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/count/feed"})
    public Map<String, Long> countFeed() {
        long count = this.metaDataRepository.countAllImportedServiceProviders();
        return Collections.singletonMap("count", count);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/feed"})
    public Map<String, List> importFeed(@Validated @RequestBody Import importRequest) {
        return this.metaDataService.importFeed(importRequest);
    }

    @PreAuthorize(value="hasRole('WRITE_SP')")
    @PostMapping(value={"/internal/update-sp/{id}/{version}"})
    public MetaData updateSP(@PathVariable(value="id") String id, @PathVariable(value="version") Long version, @Validated @RequestBody XML container, APIUser apiUser) throws IOException, XMLStreamException {
        MetaData metaData = this.metaDataService.getMetaDataAndValidate(EntityType.SP.getType(), id);
        Map innerJson = this.importerService.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.SP, Optional.empty());
        this.metaDataService.addDefaultSpData(innerJson);
        metaData.setData(innerJson);
        metaData.setVersion(version);
        return this.metaDataService.doPut(metaData, (AbstractUser)apiUser, !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('READ')")
    @GetMapping(value={"/internal/sp-metadata/{id}"})
    public String exportXml(@PathVariable(value="id") String id) throws IOException {
        MetaData metaData = this.metaDataService.getMetaDataAndValidate(EntityType.SP.getType(), id);
        return this.exporterService.exportToXml(metaData);
    }

    @PreAuthorize(value="hasRole('READ')")
    @GetMapping(value={"/internal/xml/metadata/{type}/{id}"}, produces={"text/xml"})
    public String exportMetadataXml(@PathVariable(value="type") String type, @PathVariable(value="id") String id) throws IOException {
        MetaData metaData = this.metaDataService.getMetaDataAndValidate(EntityType.fromType((String)type).getType(), id);
        return this.exporterService.exportToXml(metaData);
    }

    @PreAuthorize(value="hasRole('READ')")
    @PostMapping(value={"/internal/validate/metadata"})
    public ResponseEntity<Object> validateMetaData(@Validated @RequestBody MetaData metaData) throws JsonProcessingException {
        this.metaDataService.validate(metaData);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/metadata/{type}/{id}"})
    public boolean remove(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestBody(required=false) Map body, FederatedUser user) {
        String defaultValue = "Deleted by " + user.getUid();
        String revisionNote = body != null ? (String)((Object)body.getOrDefault("revisionNote", defaultValue)) : defaultValue;
        revisionNote = StringUtils.hasText((String)revisionNote) ? revisionNote : defaultValue;
        return this.metaDataService.doRemove(type, id, (AbstractUser)user, revisionNote);
    }

    @PreAuthorize(value="hasRole('DELETE_SP')")
    @DeleteMapping(value={"/internal/metadata/{type}/{id}"})
    public boolean removeInternal(@PathVariable(value="type") String type, @PathVariable(value="id") String id, APIUser apiUser) {
        ScopeEnforcer.enforceDeleteScope((APIUser)apiUser, (EntityType)EntityType.fromType((String)type));
        return this.metaDataService.doRemove(type, id, (AbstractUser)apiUser, "Deleted by APIUser " + apiUser.getName());
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/metadata"})
    @Transactional
    public MetaData put(@Validated @RequestBody MetaData metaData, FederatedUser user) throws JsonProcessingException {
        return this.metaDataService.doPut(metaData, (AbstractUser)user, false);
    }

    @PreAuthorize(value="hasAnyRole('WRITE_SP', 'WRITE_IDP', 'SYSTEM')")
    @PutMapping(value={"/internal/metadata"})
    @Transactional
    public MetaData putInternal(@Validated @RequestBody MetaData metaData, APIUser apiUser) throws JsonProcessingException {
        ScopeEnforcer.enforceWriteScope((APIUser)apiUser, (EntityType)EntityType.fromType((String)metaData.getType()));
        return this.metaDataService.doPut(metaData, (AbstractUser)apiUser, !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasAnyRole('SYSTEM')")
    @PutMapping(value={"/internal/removeExtraneousKeys/{type}"})
    @Transactional
    public ResponseEntity<List<String>> removeExtraneousKeys(@PathVariable(value="type") String type, @RequestBody List<String> extraneousKeys, APIUser apiUser) {
        LOG.info("RemoveExtraneousKeys called by {}", (Object)apiUser.getName());
        ArrayList results = new ArrayList();
        List metaDataEntries = this.metaDataRepository.findAllByType(type);
        metaDataEntries.forEach(metaData -> {
            Map metaDataFields = metaData.metaDataFields();
            Set keySet = metaDataFields.keySet();
            if (keySet.stream().anyMatch(key -> extraneousKeys.contains(key))) {
                keySet.removeIf(key -> extraneousKeys.contains(key));
                LOG.info(String.format("Saving %s metadata where extraneousKeys are removed", metaData.getData().get("entityid")));
                this.metaDataRepository.update(metaData);
                results.add((String)metaData.getData().get("entityid"));
            }
        });
        return ResponseEntity.ok(results);
    }

    @PreAuthorize(value="hasAnyRole('WRITE_SP', 'WRITE_IDP', 'SYSTEM')")
    @PutMapping(value={"/internal/delete-metadata-key"})
    @Transactional
    public List<String> deleteMetaDataKey(@Validated @RequestBody MetaDataKeyDelete metaDataKeyDelete, APIUser apiUser) throws IOException {
        ScopeEnforcer.enforceWriteScope((APIUser)apiUser, (EntityType)EntityType.fromType((String)metaDataKeyDelete.getType()));
        return this.metaDataService.deleteMetaDataKey(metaDataKeyDelete, apiUser);
    }

    @PreAuthorize(value="hasAnyRole('WRITE_SP', 'WRITE_IDP', 'SYSTEM')")
    @PutMapping(value={"internal/merge"})
    @Transactional
    public MetaData update(@Validated @RequestBody MetaDataUpdate metaDataUpdate, APIUser apiUser) throws JsonProcessingException {
        ScopeEnforcer.enforceWriteScope((APIUser)apiUser, (EntityType)EntityType.fromType((String)metaDataUpdate.getType()));
        return (MetaData)this.metaDataService.doMergeUpdate((PathUpdates)metaDataUpdate, (AbstractUser)apiUser, "Internal API merge", true).get();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/change-requests/{type}/{metaDataId}"})
    public List<MetaDataChangeRequest> changeRequests(@PathVariable(value="type") String type, @PathVariable(value="metaDataId") String metaDataId) {
        return this.metaDataRepository.changeRequests(metaDataId, type.concat("_change_request"));
    }

    @PreAuthorize(value="hasAnyRole('CHANGE_REQUEST_SP', 'CHANGE_REQUEST_IDP')")
    @GetMapping(value={"/internal/change-requests/{type}/{metaDataId}"})
    public List<MetaDataChangeRequest> internalChangeRequests(@PathVariable(value="type") String type, @PathVariable(value="metaDataId") String metaDataId, APIUser apiUser) {
        ScopeEnforcer.enforceChangeRequestScope((APIUser)apiUser, (EntityType)EntityType.fromType((String)type));
        return this.metaDataRepository.changeRequests(metaDataId, type.concat("_change_request"));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/change-requests/all"})
    public List<MetaDataChangeRequest> allChangeRequests() {
        return this.metaDataRepository.allChangeRequests();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"client/change-requests/count"})
    public long openChangeRequests() {
        return this.metaDataRepository.openChangeRequests();
    }

    @PreAuthorize(value="hasAnyRole('CHANGE_REQUEST_SP', 'CHANGE_REQUEST_IDP')")
    @PostMapping(value={"internal/change-requests"})
    @Transactional
    public MetaDataChangeRequest changeRequestInternal(@Validated @RequestBody MetaDataChangeRequest metaDataChangeRequest, APIUser apiUser) throws JsonProcessingException {
        ScopeEnforcer.enforceChangeRequestScope((APIUser)apiUser, (EntityType)EntityType.fromType((String)metaDataChangeRequest.getType()));
        return this.metaDataService.doChangeRequest(metaDataChangeRequest, (AbstractUser)apiUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"client/change-requests"})
    @Transactional
    public MetaDataChangeRequest changeRequestClient(@Validated @RequestBody MetaDataChangeRequest metaDataChangeRequest, FederatedUser federatedUser) throws JsonProcessingException {
        return this.metaDataService.doChangeRequest(metaDataChangeRequest, (AbstractUser)federatedUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/change-requests/accept"})
    @Transactional
    public MetaData acceptChangeRequest(@RequestBody @Validated ChangeRequest changeRequest, FederatedUser user) throws JsonProcessingException {
        String collectionName = changeRequest.getType().concat("_change_request");
        MetaDataChangeRequest metaDataChangeRequest = (MetaDataChangeRequest)this.metaDataRepository.getMongoTemplate().findById((Object)changeRequest.getId(), MetaDataChangeRequest.class, collectionName);
        MetaData metaData = (MetaData)this.metaDataService.doMergeUpdate((PathUpdates)metaDataChangeRequest, (AbstractUser)user, changeRequest.getRevisionNotes(), true).get();
        this.metaDataRepository.getMongoTemplate().remove((Object)metaDataChangeRequest, collectionName);
        return metaData;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/change-requests/reject"})
    @Transactional
    public MetaData rejectChangeRequest(@RequestBody @Validated ChangeRequest changeRequest, FederatedUser user) {
        return this.metaDataService.doRejectChangeRequest(changeRequest, (AbstractUser)user);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"/client/change-requests/remove/{type}/{metaDataId}"})
    @Transactional
    public DeleteResult removeChangeRequest(@PathVariable(value="type") String type, @PathVariable(value="metaDataId") String metaDataId, FederatedUser user) {
        return this.metaDataService.doDeleteChangeRequest(type, metaDataId, (AbstractUser)user);
    }

    @PreAuthorize(value="hasAnyRole('CHANGE_REQUEST_IDP', 'CHANGE_REQUEST_SP')")
    @PutMapping(value={"/internal/change-requests/reject"})
    @Transactional
    public MetaData internalRejectChangeRequest(@RequestBody @Validated ChangeRequest changeRequest, APIUser apiUser) {
        ScopeEnforcer.enforceChangeRequestScope((APIUser)apiUser, (EntityType)EntityType.fromType((String)changeRequest.getType()));
        return this.metaDataService.doRejectChangeRequest(changeRequest, (AbstractUser)apiUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/restoreDeleted"})
    @Transactional
    public MetaData restoreDeleted(@Validated @RequestBody RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        return this.metaDataService.restoreDeleted(revisionRestore, federatedUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/restoreRevision"})
    @Transactional
    public MetaData restoreRevision(@Validated @RequestBody RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        return this.metaDataService.restoreRevision(revisionRestore, federatedUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/revisions/{type}/{parentId}"})
    public List<MetaData> revisions(@PathVariable(value="type") String type, @PathVariable(value="parentId") String parentId) {
        return this.metaDataRepository.revisions(type.concat("_revision"), parentId);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/autocomplete/{type}"})
    public Map<String, List<Map>> autoCompleteEntities(@PathVariable(value="type") String type, @RequestParam(value="query") String query) {
        return this.metaDataService.autoCompleteEntities(type, query);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/whiteListing/{type}"})
    public List<Map> whiteListing(@PathVariable(value="type") String type, @RequestParam(value="state") String state) {
        return this.metaDataRepository.whiteListing(type, state);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/relyingParties"})
    public List<Map> relyingParties(@RequestParam(value="resourceServerEntityID") String resourceServerEntityID) {
        return this.metaDataRepository.relyingParties(resourceServerEntityID);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/spPolicies"})
    public List<Map> spPolicies(@RequestParam(value="entityId") String entityId) {
        return this.metaDataRepository.spPolicies(entityId);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/idpPolicies"})
    public List<Map> idpPolicies(@RequestParam(value="entityId") String entityId) {
        return this.metaDataRepository.idpPolicies(entityId);
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @PostMapping(value={"/client/provisioning", "/internal/provisioning"})
    public List<Map> provisioning(@RequestBody List<String> identifiers) {
        return this.metaDataRepository.provisioning(identifiers);
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @GetMapping(value={"/client/allowedEntities/{type}/{id}", "/internal/allowedEntities/{type}/{id}"})
    public List<Map> allowedEntities(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return this.metaDataRepository.allowedEntities(id, EntityType.fromType((String)type));
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @PostMapping(value={"/client/uniqueEntityId/{type}", "/internal/uniqueEntityId/{type}"})
    public List<Map> uniqueEntityId(@PathVariable(value="type") String type, @RequestBody Map<String, Object> properties) {
        String entityId = (String)properties.get("entityid");
        return this.metaDataService.uniqueEntityId(type, entityId);
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @PostMapping(value={"/client/search/{type}", "/internal/search/{type}"})
    public List<Map> searchEntities(@PathVariable(value="type") String type, @RequestBody Map<String, Object> properties, @RequestParam(required=false, defaultValue="false") boolean nested) {
        return this.metaDataService.searchEntityByType(type, properties, nested);
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @GetMapping(value={"/client/rawSearch/{type}", "/internal/rawSearch/{type}"})
    public List<MetaData> rawSearch(@PathVariable(value="type") String type, @RequestParam(value="query") String query) throws UnsupportedEncodingException {
        return this.metaDataService.retrieveRawSearch(type, query);
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @PostMapping(value={"/client/rawSearch/{type}", "/internal/rawSearch/{type}"})
    public List<MetaData> rawSearchPost(@PathVariable(value="type") String type, @RequestBody String query) throws UnsupportedEncodingException {
        return this.metaDataService.retrieveRawSearch(type, query);
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @PostMapping(value={"/client/recent-activity", "/internal/recent-activity"})
    public List<MetaData> recentActivity(@RequestBody(required=false) Map<String, Object> properties) {
        return this.metaDataService.retrieveRecentActivity(properties);
    }

    @PreAuthorize(value="hasRole('CHANGE_REQUEST_IDP')")
    @PutMapping(value={"/internal/connectWithoutInteraction"})
    public HttpEntity<HttpStatus> connectWithoutInteraction(@RequestBody Map<String, String> connectionData, APIUser apiUser) throws JsonProcessingException {
        LOG.debug("connectWithoutInteraction, connectionData: " + String.valueOf(connectionData));
        this.metaDataService.createConnectWithoutInteraction(connectionData, apiUser);
        return new HttpEntity((Object)HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('READ')")
    @GetMapping(value={"/internal/stats"})
    public Map<String, Long> stats() throws IOException {
        MongoTemplate mongoTemplate = this.metaDataRepository.getMongoTemplate();
        return Stream.of(EntityType.SP, EntityType.IDP, EntityType.RP).collect(Collectors.toMap(entityType -> entityType.getType(), entityType -> mongoTemplate.count(new Query(), entityType.getType())));
    }
}

