/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import manage.control.RestTemplateIdiom;
import manage.web.HttpHostProvider;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class RestTemplateIdiom {
    private RestTemplateIdiom() {
    }

    public static RestTemplate buildRestTemplate(String uri, String userName, String password) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager());
        if (StringUtils.hasText((String)uri)) {
            Optional optionalHttpHost = HttpHostProvider.resolveHttpHost((URL)URI.create(uri).toURL());
            optionalHttpHost.ifPresent(httpHost -> httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(httpHost)));
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        return builder.requestFactory(() -> requestFactory).additionalInterceptors(List.of(new BasicAuthenticationInterceptor(userName, password), new CookieRemoveInterceptor())).build();
    }
}

