/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manage.control.RestTemplateIdiom;
import manage.format.EngineBlockFormatter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.model.PushOptions;
import manage.model.Scope;
import manage.policies.PdpPolicyDefinition;
import manage.repository.MetaDataRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@Component
@RestController
public class DatabaseController {
    private final RestTemplate restTemplate;
    private final String pushUri;
    private final RestTemplate oidcRestTemplate;
    private final String oidcPushUri;
    private final boolean oidcEnabled;
    private final boolean excludeEduGainImported;
    private final boolean excludeOidcRP;
    private final boolean excludeSRAM;
    private final MetaDataRepository metaDataRepository;
    private final Environment environment;
    private final String pdpPushUri;
    private final RestTemplate pdpRestTemplate;
    private final boolean pdpEnabled;

    @Autowired
    DatabaseController(MetaDataRepository metaDataRepository, @Value(value="${push.eb.url}") String pushUri, @Value(value="${push.eb.user}") String user, @Value(value="${push.eb.password}") String password, @Value(value="${push.eb.exclude_edugain_imports}") boolean excludeEduGainImported, @Value(value="${push.eb.exclude_oidc_rp}") boolean excludeOidcRP, @Value(value="${push.eb.exclude_sram}") boolean excludeSRAM, @Value(value="${push.oidc.url}") String oidcPushUri, @Value(value="${push.oidc.user}") String oidcUser, @Value(value="${push.oidc.password}") String oidcPassword, @Value(value="${push.pdp.url}") String pdpPushUri, @Value(value="${push.pdp.user}") String pdpUser, @Value(value="${push.pdp.password}") String pdpPassword, @Value(value="${push.pdp.enabled}") boolean pdpEnabled, @Value(value="${push.oidc.enabled}") boolean oidcEnabled, Environment environment) {
        this.metaDataRepository = metaDataRepository;
        this.pushUri = pushUri;
        this.restTemplate = RestTemplateIdiom.buildRestTemplate((String)pushUri, (String)user, (String)password);
        this.excludeEduGainImported = excludeEduGainImported;
        this.excludeOidcRP = excludeOidcRP;
        this.excludeSRAM = excludeSRAM;
        this.oidcRestTemplate = RestTemplateIdiom.buildRestTemplate((String)oidcPushUri, (String)oidcUser, (String)oidcPassword);
        this.oidcPushUri = oidcPushUri;
        this.oidcEnabled = oidcEnabled;
        this.pdpRestTemplate = RestTemplateIdiom.buildRestTemplate((String)pdpPushUri, (String)pdpUser, (String)pdpPassword);
        this.pdpPushUri = pdpPushUri;
        this.pdpEnabled = pdpEnabled;
        this.environment = environment;
    }

    public ResponseEntity<Map> doPush(PushOptions pushOptions) {
        ResponseEntity response;
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}))) {
            return new ResponseEntity(Map.of("eb", Map.of("status", "OK"), "pdp", Map.of("status", "OK"), "oidc", Map.of("status", "OK")), (HttpStatusCode)HttpStatus.OK);
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (pushOptions.isIncludePdP() && this.pdpEnabled) {
            List policies = this.pushPreviewPdP();
            this.pdpRestTemplate.put(this.pdpPushUri, (Object)policies, new Object[0]);
            result.put("pdp", Map.of("status", "OK"));
        } else {
            result.put("pdp", Map.of("status", "OK"));
        }
        if (pushOptions.isIncludeEB()) {
            Map json = this.pushPreview();
            response = this.restTemplate.postForEntity(this.pushUri, (Object)json, String.class, new Object[0]);
            String body = (String)response.getBody();
            result.put("eb", Map.of("status", response.getStatusCode().is2xxSuccessful() ? "OK" : "ERROR", "response", StringUtils.hasText((String)body) ? body : ""));
        } else {
            result.put("eb", Map.of("status", "OK"));
        }
        if (!this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})) && this.oidcEnabled && pushOptions.isIncludeOIDC()) {
            List filteredEntities = this.pushPreviewOIDC();
            response = this.oidcRestTemplate.postForEntity(this.oidcPushUri, (Object)filteredEntities, Void.class, new Object[0]);
            result.put("oidc", Map.of("status", response.getStatusCode().is2xxSuccessful() ? "OK" : "ERROR"));
        } else {
            result.put("oidc", Map.of("status", "OK"));
        }
        return new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
    }

    private List<PdpPolicyDefinition> pushPreviewPdP() {
        List<PdpPolicyDefinition> policies = this.metaDataRepository.findAllByType(EntityType.PDP.getType()).stream().map(PdpPolicyDefinition::new).filter(PdpPolicyDefinition::isActive).collect(Collectors.toList());
        return policies;
    }

    private List<MetaData> pushPreviewOIDC() {
        List relyingParties = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.RP.getType());
        List resourceServers = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.RS.getType());
        List scopes = this.metaDataRepository.getMongoTemplate().findAll(Scope.class);
        Map<String, Scope> scopesMapped = scopes.stream().collect(Collectors.toMap(Scope::getName, scope -> scope));
        resourceServers.forEach(rs -> {
            rs.setType(EntityType.RP.getType());
            Map metaDataFields = rs.metaDataFields();
            metaDataFields.put("isResourceServer", true);
            List scopeList = (List)metaDataFields.get("scopes");
            if (!CollectionUtils.isEmpty((Collection)scopeList)) {
                List transformedScope = scopeList.stream().map(scope -> scopesMapped.getOrDefault(scope, null)).filter(Objects::nonNull).collect(Collectors.toList());
                metaDataFields.put("scopes", transformedScope);
            }
        });
        if (!this.excludeSRAM) {
            List sramRelyingParties = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.SRAM.getType());
            sramRelyingParties.forEach(sramEntity -> sramEntity.metaDataFields().put("coin:collab_enabled", true));
            relyingParties.addAll(sramRelyingParties);
        }
        relyingParties.forEach(rp -> {
            Map metaDataFields = rp.metaDataFields();
            metaDataFields.put("isResourceServer", false);
            metaDataFields.remove("scopes");
        });
        relyingParties.addAll(resourceServers);
        List<MetaData> filteredEntities = relyingParties.stream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toList());
        return filteredEntities;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/pushPreview"})
    public Map<String, Map<String, Map<String, Object>>> pushPreview() {
        EngineBlockFormatter formatter = new EngineBlockFormatter();
        List serviceProviders = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.SP.getType());
        Stream metaDataStream = this.excludeEduGainImported ? serviceProviders.stream().filter(metaData -> {
            Map metaDataFields = metaData.metaDataFields();
            boolean importedFromEdugain = Boolean.TRUE.equals(metaDataFields.get("coin:imported_from_edugain"));
            boolean pushEnabled = Boolean.TRUE.equals(metaDataFields.get("coin:push_enabled"));
            return !importedFromEdugain || pushEnabled;
        }) : serviceProviders.stream();
        Map<String, Map> serviceProvidersToPush = metaDataStream.filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseServiceProvider(arg_0)));
        List identityProviders = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.IDP.getType());
        this.filterOutNullDisableConsentExplanations(identityProviders);
        Map<String, Map> identityProvidersToPush = identityProviders.stream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseIdentityProvider(arg_0)));
        if (!this.excludeOidcRP) {
            List relyingParties = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.RP.getType());
            Map<String, Map> oidcClientsToPush = relyingParties.stream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseOidcClient(arg_0)));
            serviceProvidersToPush.putAll(oidcClientsToPush);
        }
        if (!this.excludeSRAM) {
            List sramServices = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.SRAM.getType());
            sramServices.forEach(sramEntity -> sramEntity.metaDataFields().put("coin:collab_enabled", true));
            Map<String, Map> sramServicesToProvidersToPush = sramServices.stream().collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseServiceProvider(arg_0)));
            serviceProvidersToPush.putAll(sramServicesToProvidersToPush);
        }
        serviceProvidersToPush.putAll(identityProvidersToPush);
        HashMap<String, Map<String, Map<String, Object>>> results = new HashMap<String, Map<String, Map<String, Object>>>();
        results.put("connections", serviceProvidersToPush);
        return results;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/pushPreviewOIDC"})
    public List<MetaData> pushPreviewOIDCEndpoint() {
        return this.pushPreviewOIDC();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/pushPreviewPdP"})
    public List<PdpPolicyDefinition> pushPreviewPdPEndpoint() {
        return this.pushPreviewPdP();
    }

    private boolean excludeFromPush(Map metaDataFields) {
        Boolean excludeFromPush = metaDataFields.getOrDefault("coin:exclude_from_push", false);
        if (excludeFromPush instanceof String) {
            return "1".equals(excludeFromPush);
        }
        return excludeFromPush;
    }

    public void filterOutNullDisableConsentExplanations(List<MetaData> identityProviders) {
        identityProviders.forEach(idp -> {
            Object disableConsentData = idp.getData().get("disableConsent");
            if (disableConsentData instanceof List) {
                List disableConsent = (List)disableConsentData;
                disableConsent.forEach(disableConsentEntry -> {
                    if (disableConsentEntry instanceof Map) {
                        Map disableConsentMap = (Map)disableConsentEntry;
                        disableConsentMap.entrySet().removeIf(entry -> entry.getValue() == null);
                    }
                });
            }
        });
    }
}

