/*
 * Decompiled with CFR 0.152.
 */
package monitoring.eb;

import java.util.concurrent.TimeUnit;
import monitoring.Monitor;
import org.apache.commons.lang3.StringEscapeUtils;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SamlProxyMonitor
implements Monitor {
    private WebDriver driver;
    private String mujinaServiceProviderBaseUrl;
    private String idpEntityId;
    private String userName;

    public SamlProxyMonitor(@Value(value="${eb.mujina_sp_base_url}") String mujinaServiceProviderBaseUrl, @Value(value="${eb.mujina_idp_entity_id}") String idpEntityId, @Value(value="${eb.mujina_username}") String userName) {
        this.mujinaServiceProviderBaseUrl = mujinaServiceProviderBaseUrl;
        this.userName = userName;
        this.idpEntityId = idpEntityId;
    }

    public void monitor() {
        try {
            this.doMonitor();
        }
        catch (RuntimeException e) {
            LOG.warn("Exception occurred. Current page is {} and pageSource is {}", (Object)this.driver.getCurrentUrl(), (Object)this.driver.getPageSource());
            throw e;
        }
    }

    private void doMonitor() {
        this.driver = new HtmlUnitDriver(false);
        this.driver.manage().deleteAllCookies();
        this.driver.manage().timeouts().implicitlyWait(5L, TimeUnit.MINUTES).pageLoadTimeout(5L, TimeUnit.MINUTES).setScriptTimeout(5L, TimeUnit.MINUTES);
        this.driver.get(this.mujinaServiceProviderBaseUrl + "/user.html");
        boolean wayf = this.driver.getPageSource().contains("Select an institution to login to the service");
        if (wayf) {
            WebElement login = this.driver.findElement(By.xpath((String)String.format("//input[@data-entityid=\"%s\"]", StringEscapeUtils.escapeXml11((String)this.idpEntityId))));
            login.click();
        }
        this.driver.findElement(By.xpath((String)"//input[@value=\"Submit\"]")).click();
        this.driver.findElement(By.name((String)"username")).sendKeys(new CharSequence[]{this.userName});
        this.driver.findElement(By.name((String)"password")).sendKeys(new CharSequence[]{"secret"});
        this.driver.findElement(By.xpath((String)"//input[@value=\"Log in\"]")).submit();
        this.driver.findElement(By.xpath((String)"//input[@value=\"Continue\"]")).click();
        if (this.driver.getPageSource().contains("Yes, share this data")) {
            this.driver.findElement(By.id((String)"accept_terms_button")).submit();
        }
        this.driver.findElement(By.xpath((String)"//input[@value=\"Submit\"]")).click();
        this.driver.findElement(By.className((String)"attributes"));
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((String)String.format("Page should contain %s j.doe@example.com", pageSource), (boolean)pageSource.contains("j.doe@example.com"));
    }
}

