/*
 * Decompiled with CFR 0.152.
 */
package monitoring.voot;

import java.util.Collections;
import java.util.List;
import monitoring.Monitor;
import org.junit.Assert;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;

public abstract class AbstractVootMonitor
implements Monitor {
    private static final String nonExistingPersonId = "urn:collab:person:some-nonexisting-org:monitoring-user";
    private String authorizationURL;
    private String vootBaseUrl;
    private String clientId;
    private String secret;
    private String personId;

    protected AbstractVootMonitor(String authorizationURL, String vootBaseUrl, String clientId, String secret, String personId) {
        this.authorizationURL = authorizationURL;
        this.vootBaseUrl = vootBaseUrl;
        this.clientId = clientId;
        this.secret = secret;
        this.personId = personId;
    }

    public void monitor() throws InterruptedException {
        ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
        details.setAccessTokenUri(this.authorizationURL);
        details.setClientId(this.clientId);
        details.setClientSecret(this.secret);
        details.setScope(Collections.singletonList("groups"));
        OAuth2RestTemplate template = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)details);
        template.getAccessToken();
        Thread.sleep(2500L);
        this.doMonitor(true, 1, template);
    }

    private void doMonitor(boolean retry, int count, OAuth2RestTemplate template) {
        String url = this.vootBaseUrl + "/internal/groups/{userId}";
        try {
            List groups = (List)template.getForObject(url, List.class, new Object[]{this.personId});
            Assert.assertFalse((String)(this.personId + " must have group memberships"), (boolean)groups.isEmpty());
            groups = (List)template.getForObject(url, List.class, new Object[]{nonExistingPersonId});
            Assert.assertTrue((String)"urn:collab:person:some-nonexisting-org:monitoring-user must not have memberships", (boolean)groups.isEmpty());
        }
        catch (RuntimeException e) {
            if (retry) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e);
                }
                this.doMonitor(count < 5, count + 1, template);
            }
            throw e;
        }
    }
}

