/*
 * Decompiled with CFR 0.152.
 */
package monitoring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public interface Monitor
extends HealthIndicator {
    public static final Logger LOG = LoggerFactory.getLogger(Monitor.class);

    public void monitor() throws Exception;

    default public Health health() {
        try {
            this.monitor();
            return Health.up().build();
        }
        catch (Throwable e) {
            LOG.error("Exception in health " + this.getClass(), e);
            return Health.down().withDetail(String.format("Error in monitor %s", this.getClass()), (Object)e.getMessage()).build();
        }
    }
}

