/*
 * Decompiled with CFR 0.152.
 */
package monitoring.voot;

import java.util.Collections;
import java.util.List;
import monitoring.Monitor;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.stereotype.Component;

@Component
public class VootMonitor
implements Monitor {
    private static final String nonExistingPersonId = "urn:collab:person:some-nonexisting-org:monitoring-user";
    private String authzServerBaseUrl;
    private String vootBaseUrl;
    private String clientId;
    private String secret;
    private String personId;

    public VootMonitor(@Value(value="${voot.authz_server_base_url}") String authzServerBaseUrl, @Value(value="${voot.voot_base_url}") String vootBaseUrl, @Value(value="${voot.client_id}") String clientId, @Value(value="${voot.secret}") String secret, @Value(value="${voot.person_id}") String personId) {
        this.authzServerBaseUrl = authzServerBaseUrl;
        this.vootBaseUrl = vootBaseUrl;
        this.clientId = clientId;
        this.secret = secret;
        this.personId = personId;
    }

    public void monitor() throws Exception {
        ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
        details.setAccessTokenUri(this.authzServerBaseUrl + "/oauth/token");
        details.setClientId(this.clientId);
        details.setClientSecret(this.secret);
        details.setScope(Collections.singletonList("groups"));
        OAuth2RestTemplate template = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)details);
        String url = this.vootBaseUrl + "/internal/groups/{userId}";
        List groups = (List)template.getForObject(url, List.class, new Object[]{this.personId});
        Assert.assertFalse((String)(this.personId + " must have group memberships"), (boolean)groups.isEmpty());
        groups = (List)template.getForObject(url, List.class, new Object[]{nonExistingPersonId});
        Assert.assertTrue((String)"urn:collab:person:some-nonexisting-org:monitoring-user must not have memberships", (boolean)groups.isEmpty());
    }
}

