/*
 * Decompiled with CFR 0.152.
 */
package monitoring.pdp;

import java.io.InputStream;
import monitoring.Monitor;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class PdPMonitor
implements Monitor {
    private String pdpUserName;
    private String pdpPassword;
    private String idpEntityId;
    private String spEntityId;
    private String pdpBaseUrl;

    public PdPMonitor(@Value(value="${pdp.user}") String pdpUserName, @Value(value="${pdp.password}") String pdpPassword, @Value(value="${pdp.idp_entity_id}") String idpEntityId, @Value(value="${pdp.sp_entity_id}") String spEntityId, @Value(value="${pdp.base_url}") String pdpBaseUrl) {
        this.pdpUserName = pdpUserName;
        this.pdpPassword = pdpPassword;
        this.idpEntityId = idpEntityId;
        this.spEntityId = spEntityId;
        this.pdpBaseUrl = pdpBaseUrl;
    }

    public void monitor() throws Exception {
        TestRestTemplate restTemplate = new TestRestTemplate(this.pdpUserName, this.pdpPassword, new TestRestTemplate.HttpClientOption[0]);
        String body = IOUtils.toString((InputStream)new ClassPathResource("pdp/request.json").getInputStream());
        body = body.replaceAll("@@IDP_ENTITY_ID@@", this.idpEntityId);
        body = body.replaceAll("@@SP_ENTITY_ID@@", this.spEntityId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(this.pdpBaseUrl + "/pdp/api/decide/policy", HttpMethod.POST, httpEntity, String.class, new Object[0]);
        Assert.assertEquals((String)"The response status must be 200", (long)200L, (long)response.getStatusCode().value());
        Assert.assertTrue((String)"The body must contain 'urn:oasis:names:tc:xacml:1.0:status:ok'", (boolean)((String)response.getBody()).contains("urn:oasis:names:tc:xacml:1.0:status:ok"));
        Assert.assertTrue((String)"The body must contain 'NotApplicable'", (boolean)((String)response.getBody()).contains("NotApplicable"));
    }
}

