/*
 * Decompiled with CFR 0.152.
 */
package monitoring.eb;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import monitoring.Monitor;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class MetadataMonitor
implements Monitor {
    private RestTemplate restTemplate;
    private String engineBlockMetatadaBaseUrl;
    private Pattern pattern = Pattern.compile("validUntil=\"(.*?)\"");
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.systemDefault());

    public MetadataMonitor(@Value(value="${eb.metadata_base_url}") String engineBlockMetatadaBaseUrl) {
        this.engineBlockMetatadaBaseUrl = engineBlockMetatadaBaseUrl;
        this.restTemplate = new RestTemplate();
    }

    public void monitor() throws Exception {
        this.metadata(this.restTemplate, "/authentication/idp/metadata");
        this.metadata(this.restTemplate, "/authentication/sp/metadata");
    }

    private void metadata(RestTemplate restTemplate, String path) {
        String url = this.engineBlockMetatadaBaseUrl + path;
        ResponseEntity responseEntity = restTemplate.getForEntity(url, String.class, new Object[0]);
        Assert.assertEquals((String)"EngineBlock IDP metadata", (Object)HttpStatus.OK, (Object)responseEntity.getStatusCode());
        ZonedDateTime halfDayFromNow = ZonedDateTime.now(ZoneId.systemDefault()).plusHours(12L);
        Assert.assertTrue((String)"validUntil of the metadata should be at least 12 hrs in future", (boolean)this.validUntil((String)responseEntity.getBody()).isAfter(halfDayFromNow));
    }

    private ZonedDateTime validUntil(String metaData) {
        Matcher matcher = this.pattern.matcher(metaData);
        matcher.find();
        String validUntil = matcher.group(1);
        return ZonedDateTime.parse(validUntil, this.dateTimeFormatter);
    }
}

