/*
 * Decompiled with CFR 0.152.
 */
package monitoring.oidcng;

import java.util.Map;
import monitoring.Monitor;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class OidcNGMonitor
implements Monitor {
    private String resourceServerId;
    private String resourceServerSecret;
    private String baseURL;
    private String clientId;
    private String secret;

    public OidcNGMonitor(@Value(value="${oidcng.base_url}") String baseURL, @Value(value="${oidcng.client_id}") String clientId, @Value(value="${oidcng.secret}") String secret, @Value(value="${oidcng.resource_server_id}") String resourceServerId, @Value(value="${oidcng.resource_server_secret}") String resourceServerSecret) {
        this.baseURL = baseURL;
        this.clientId = clientId;
        this.secret = secret;
        this.resourceServerId = resourceServerId;
        this.resourceServerSecret = resourceServerSecret;
    }

    public void monitor() throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"client_credentials");
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity response = new TestRestTemplate(this.clientId, this.secret, new TestRestTemplate.HttpClientOption[0]).postForEntity(this.baseURL + "/token", (Object)request, Map.class, new Object[0]);
        String accessToken = (String)((Map)response.getBody()).get("access_token");
        request = new HttpEntity((MultiValueMap)headers);
        response = new TestRestTemplate(this.resourceServerId, this.resourceServerSecret, new TestRestTemplate.HttpClientOption[0]).postForEntity(this.baseURL + "/introspect?token=" + accessToken, (Object)request, Map.class, new Object[0]);
        Assert.assertEquals((Object)true, ((Map)response.getBody()).get("active"));
    }
}

