/*
 * Decompiled with CFR 0.152.
 */
package mujina.saml;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import mujina.saml.SAMLAttribute;
import mujina.saml.SAMLPrincipal;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthenticatingAuthority;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SAMLBuilder {
    private static final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public static <T> T buildSAMLObject(Class<T> objectClass, QName qName) {
        return (T)builderFactory.getBuilder(qName).buildObject(qName);
    }

    public static Issuer buildIssuer(String issuingEntityName) {
        Issuer issuer = SAMLBuilder.buildSAMLObject(Issuer.class, Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(issuingEntityName);
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        return issuer;
    }

    private static Subject buildSubject(String subjectNameId, String subjectNameIdType, String recipient, String inResponseTo) {
        NameID nameID = SAMLBuilder.buildSAMLObject(NameID.class, NameID.DEFAULT_ELEMENT_NAME);
        nameID.setValue(subjectNameId);
        nameID.setFormat(subjectNameIdType);
        Subject subject = SAMLBuilder.buildSAMLObject(Subject.class, Subject.DEFAULT_ELEMENT_NAME);
        subject.setNameID(nameID);
        SubjectConfirmation subjectConfirmation = SAMLBuilder.buildSAMLObject(SubjectConfirmation.class, SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationData subjectConfirmationData = SAMLBuilder.buildSAMLObject(SubjectConfirmationData.class, SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        subjectConfirmationData.setRecipient(recipient);
        subjectConfirmationData.setInResponseTo(inResponseTo);
        subjectConfirmationData.setNotOnOrAfter(new DateTime().plusMinutes(480));
        subjectConfirmationData.setAddress(recipient);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        return subject;
    }

    public static Status buildStatus(String value) {
        Status status = SAMLBuilder.buildSAMLObject(Status.class, Status.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = SAMLBuilder.buildSAMLObject(StatusCode.class, StatusCode.DEFAULT_ELEMENT_NAME);
        statusCode.setValue(value);
        status.setStatusCode(statusCode);
        return status;
    }

    public static Status buildStatus(String value, String subStatus, String message) {
        Status status = SAMLBuilder.buildStatus(value);
        StatusCode subStatusCode = SAMLBuilder.buildSAMLObject(StatusCode.class, StatusCode.DEFAULT_ELEMENT_NAME);
        subStatusCode.setValue(subStatus);
        status.getStatusCode().setStatusCode(subStatusCode);
        StatusMessage statusMessage = SAMLBuilder.buildSAMLObject(StatusMessage.class, StatusMessage.DEFAULT_ELEMENT_NAME);
        statusMessage.setMessage(message);
        status.setStatusMessage(statusMessage);
        return status;
    }

    public static Assertion buildAssertion(SAMLPrincipal principal, Status status, String entityId) {
        Assertion assertion = SAMLBuilder.buildSAMLObject(Assertion.class, Assertion.DEFAULT_ELEMENT_NAME);
        if (status.getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            Subject subject = SAMLBuilder.buildSubject(principal.getNameID(), principal.getNameIDType(), principal.getAssertionConsumerServiceURL(), principal.getRequestID());
            assertion.setSubject(subject);
        }
        Issuer issuer = SAMLBuilder.buildIssuer(entityId);
        Audience audience = SAMLBuilder.buildSAMLObject(Audience.class, Audience.DEFAULT_ELEMENT_NAME);
        audience.setAudienceURI(principal.getServiceProviderEntityID());
        AudienceRestriction audienceRestriction = SAMLBuilder.buildSAMLObject(AudienceRestriction.class, AudienceRestriction.DEFAULT_ELEMENT_NAME);
        audienceRestriction.getAudiences().add(audience);
        Conditions conditions = SAMLBuilder.buildSAMLObject(Conditions.class, Conditions.DEFAULT_ELEMENT_NAME);
        conditions.getAudienceRestrictions().add(audienceRestriction);
        assertion.setConditions(conditions);
        AuthnStatement authnStatement = SAMLBuilder.buildAuthnStatement(new DateTime(), entityId);
        assertion.setIssuer(issuer);
        assertion.getAuthnStatements().add(authnStatement);
        assertion.getAttributeStatements().add(SAMLBuilder.buildAttributeStatement(principal.getAttributes()));
        assertion.setID(SAMLBuilder.randomSAMLId());
        assertion.setIssueInstant(new DateTime());
        return assertion;
    }

    public static void signAssertion(SignableXMLObject signableXMLObject, Credential signingCredential) throws MarshallingException, SignatureException {
        Signature signature = SAMLBuilder.buildSAMLObject(Signature.class, Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential(signingCredential);
        signature.setSignatureAlgorithm(Configuration.getGlobalSecurityConfiguration().getSignatureAlgorithmURI(signingCredential));
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signableXMLObject.setSignature(signature);
        Configuration.getMarshallerFactory().getMarshaller((XMLObject)signableXMLObject).marshall((XMLObject)signableXMLObject);
        Signer.signObject((Signature)signature);
    }

    public static Optional<String> getStringValueFromXMLObject(XMLObject xmlObj) {
        if (xmlObj instanceof XSString) {
            return Optional.of(((XSString)xmlObj).getValue());
        }
        if (xmlObj instanceof XSAny) {
            XMLObject xmlObject;
            XSAny xsAny = (XSAny)xmlObj;
            String textContent = xsAny.getTextContent();
            if (StringUtils.hasText((String)textContent)) {
                return Optional.of(textContent);
            }
            List unknownXMLObjects = xsAny.getUnknownXMLObjects();
            if (!CollectionUtils.isEmpty((Collection)unknownXMLObjects) && (xmlObject = (XMLObject)unknownXMLObjects.get(0)) instanceof NameID) {
                NameID nameID = (NameID)xmlObject;
                return Optional.of(nameID.getValue());
            }
        }
        return Optional.empty();
    }

    public static String randomSAMLId() {
        return "_" + UUID.randomUUID().toString();
    }

    private static AuthnStatement buildAuthnStatement(DateTime authnInstant, String entityID) {
        AuthnContextClassRef authnContextClassRef = SAMLBuilder.buildSAMLObject(AuthnContextClassRef.class, AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        AuthenticatingAuthority authenticatingAuthority = SAMLBuilder.buildSAMLObject(AuthenticatingAuthority.class, AuthenticatingAuthority.DEFAULT_ELEMENT_NAME);
        authenticatingAuthority.setURI(entityID);
        AuthnContext authnContext = SAMLBuilder.buildSAMLObject(AuthnContext.class, AuthnContext.DEFAULT_ELEMENT_NAME);
        authnContext.setAuthnContextClassRef(authnContextClassRef);
        authnContext.getAuthenticatingAuthorities().add(authenticatingAuthority);
        AuthnStatement authnStatement = SAMLBuilder.buildSAMLObject(AuthnStatement.class, AuthnStatement.DEFAULT_ELEMENT_NAME);
        authnStatement.setAuthnContext(authnContext);
        authnStatement.setAuthnInstant(authnInstant);
        return authnStatement;
    }

    private static AttributeStatement buildAttributeStatement(List<SAMLAttribute> attributes) {
        AttributeStatement attributeStatement = SAMLBuilder.buildSAMLObject(AttributeStatement.class, AttributeStatement.DEFAULT_ELEMENT_NAME);
        attributes.forEach(entry -> attributeStatement.getAttributes().add(SAMLBuilder.buildAttribute(entry.getName(), entry.getValues())));
        return attributeStatement;
    }

    private static Attribute buildAttribute(String name, List<String> values) {
        XSStringBuilder stringBuilder = (XSStringBuilder)Configuration.getBuilderFactory().getBuilder(XSString.TYPE_NAME);
        Attribute attribute = SAMLBuilder.buildSAMLObject(Attribute.class, Attribute.DEFAULT_ELEMENT_NAME);
        attribute.setName(name);
        attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        List xsStringList = values.stream().map(value -> {
            XSString stringValue = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            stringValue.setValue(value);
            return stringValue;
        }).collect(Collectors.toList());
        attribute.getAttributeValues().addAll(xsStringList);
        return attribute;
    }
}

