/*
 * Decompiled with CFR 0.152.
 */
package mujina.api;

import mujina.api.Credential;
import mujina.api.SharedConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public class SharedController {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected SharedConfiguration configuration;

    public SharedController(SharedConfiguration configuration) {
        this.configuration = configuration;
    }

    @PostMapping(value={"/reset"})
    public void reset() {
        this.LOG.info("Resetting to default configuration");
        this.configuration.reset();
    }

    @PutMapping(value={"/entityid"})
    public void setEntityID(@RequestBody String entityID) {
        this.LOG.info("Request to set entityID {}", (Object)entityID);
        this.configuration.setEntityId(entityID);
    }

    @PostMapping(value={"/signing-credential"})
    public void setSigningCredential(@RequestBody Credential credential) {
        this.LOG.info("Request to set signing credential {}", (Object)credential);
        this.configuration.injectCredential(credential.getCertificate(), credential.getKey());
    }

    @PutMapping(value={"/needs-signing"})
    public void setSigningNeeded(@RequestBody boolean needsSigning) {
        this.LOG.info("Request to set signing needed {}", (Object)needsSigning);
        this.configuration.setNeedsSigning(needsSigning);
    }

    @PutMapping(value={"/signatureAlgorithm"})
    public void setSignatureAlgorithm(@RequestBody String signatureAlgorithm) {
        this.LOG.info("Request to set signatureAlgorithm to {}", (Object)signatureAlgorithm);
        this.configuration.setSignatureAlgorithm(signatureAlgorithm);
    }
}

