/*
 * Decompiled with CFR 0.152.
 */
package mujina.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.Enumeration;
import mujina.saml.KeyStoreLocator;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.security.BasicSecurityConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.key.JKSKeyManager;

public abstract class SharedConfiguration {
    @JsonIgnore
    protected static final Logger LOG = LoggerFactory.getLogger(SharedConfiguration.class);
    @JsonIgnore
    private JKSKeyManager keyManager;
    private String keystorePassword = "secret";
    private boolean needsSigning;
    private String defaultSignatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private String signatureAlgorithm;
    private String entityId;

    public SharedConfiguration(JKSKeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public abstract void reset();

    public void setEntityId(String newEntityId, boolean addTokenToStore) {
        if (addTokenToStore) {
            try {
                KeyStore keyStore = this.keyManager.getKeyStore();
                KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(this.keystorePassword.toCharArray());
                KeyStore.Entry keyStoreEntry = keyStore.getEntry(this.entityId, passwordProtection);
                keyStore.setEntry(newEntityId, keyStoreEntry, passwordProtection);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
                throw new RuntimeException(e);
            }
        }
        this.entityId = newEntityId;
    }

    public void injectCredential(String certificate, String pemKey) {
        try {
            KeyStore keyStore = this.keyManager.getKeyStore();
            if (keyStore.containsAlias(this.entityId)) {
                keyStore.deleteEntry(this.entityId);
            }
            KeyStoreLocator.addPrivateKey(keyStore, this.entityId, pemKey, certificate, this.keystorePassword);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to append signing credential", e);
        }
    }

    protected void resetKeyStore(String alias, String privateKey, String certificate) {
        try {
            KeyStore keyStore = this.keyManager.getKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                keyStore.deleteEntry(aliases.nextElement());
            }
            KeyStoreLocator.addPrivateKey(keyStore, alias, privateKey, certificate, this.getKeystorePassword());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        ((BasicSecurityConfiguration)BasicSecurityConfiguration.class.cast(Configuration.getGlobalSecurityConfiguration())).registerSignatureAlgorithmURI("RSA", signatureAlgorithm);
    }

    public JKSKeyManager getKeyManager() {
        return this.keyManager;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public boolean isNeedsSigning() {
        return this.needsSigning;
    }

    public String getDefaultSignatureAlgorithm() {
        return this.defaultSignatureAlgorithm;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getEntityId() {
        return this.entityId;
    }

    @JsonIgnore
    public void setKeyManager(JKSKeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setNeedsSigning(boolean needsSigning) {
        this.needsSigning = needsSigning;
    }

    public void setDefaultSignatureAlgorithm(String defaultSignatureAlgorithm) {
        this.defaultSignatureAlgorithm = defaultSignatureAlgorithm;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }
}

