/*
 * Decompiled with CFR 0.152.
 */
package mujina.idp;

import java.util.Arrays;
import mujina.api.AuthenticationMethod;
import mujina.api.IdpConfiguration;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AuthenticationProvider
implements org.springframework.security.authentication.AuthenticationProvider {
    private final IdpConfiguration idpConfiguration;

    public AuthenticationProvider(IdpConfiguration idpConfiguration) {
        this.idpConfiguration = idpConfiguration;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (this.idpConfiguration.getAuthenticationMethod().equals((Object)AuthenticationMethod.ALL)) {
            return new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), Arrays.asList(new SimpleGrantedAuthority("ROLE_ADMIN"), new SimpleGrantedAuthority("ROLE_USER")));
        }
        return (Authentication)this.idpConfiguration.getUsers().stream().filter(token -> token.getPrincipal().equals(authentication.getPrincipal()) && token.getCredentials().equals(authentication.getCredentials())).findFirst().map(usernamePasswordAuthenticationToken -> new UsernamePasswordAuthenticationToken(usernamePasswordAuthenticationToken.getPrincipal(), usernamePasswordAuthenticationToken.getCredentials(), usernamePasswordAuthenticationToken.getAuthorities())).orElseThrow(() -> new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

