/*
 * Decompiled with CFR 0.152.
 */
package mujina.idp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import mujina.api.IdpConfiguration;
import mujina.saml.ProxiedSAMLContextProviderLB;
import mujina.saml.SAMLBuilder;
import mujina.saml.SAMLPrincipal;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.ValidatorSuite;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.key.KeyManager;

public class SAMLMessageHandler {
    private final KeyManager keyManager;
    private final Collection<SAMLMessageDecoder> decoders;
    private final SAMLMessageEncoder encoder;
    private final SecurityPolicyResolver resolver;
    private final IdpConfiguration idpConfiguration;
    private final List<ValidatorSuite> validatorSuites;
    private final ProxiedSAMLContextProviderLB proxiedSAMLContextProviderLB;

    public SAMLMessageHandler(KeyManager keyManager, Collection<SAMLMessageDecoder> decoders, SAMLMessageEncoder encoder, SecurityPolicyResolver securityPolicyResolver, IdpConfiguration idpConfiguration, String idpBaseUrl) throws URISyntaxException {
        this.keyManager = keyManager;
        this.encoder = encoder;
        this.decoders = decoders;
        this.resolver = securityPolicyResolver;
        this.idpConfiguration = idpConfiguration;
        this.validatorSuites = Arrays.asList(Configuration.getValidatorSuite((String)"saml2-core-schema-validator"), Configuration.getValidatorSuite((String)"saml2-core-spec-validator"));
        this.proxiedSAMLContextProviderLB = new ProxiedSAMLContextProviderLB(new URI(idpBaseUrl));
    }

    public SAMLMessageContext extractSAMLMessageContext(HttpServletRequest request, HttpServletResponse response, boolean postRequest) throws ValidationException, SecurityException, MessageDecodingException, MetadataProviderException {
        SAMLMessageContext messageContext = new SAMLMessageContext();
        this.proxiedSAMLContextProviderLB.populateGenericContext(request, response, messageContext);
        messageContext.setSecurityPolicyResolver(this.resolver);
        SAMLMessageDecoder samlMessageDecoder = this.samlMessageDecoder(postRequest);
        samlMessageDecoder.decode((MessageContext)messageContext);
        SAMLObject inboundSAMLMessage = messageContext.getInboundSAMLMessage();
        AuthnRequest authnRequest = (AuthnRequest)inboundSAMLMessage;
        for (ValidatorSuite validatorSuite : this.validatorSuites) {
            validatorSuite.validate((XMLObject)authnRequest);
        }
        return messageContext;
    }

    private SAMLMessageDecoder samlMessageDecoder(boolean postRequest) {
        return this.decoders.stream().filter(samlMessageDecoder -> postRequest ? samlMessageDecoder.getBindingURI().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST") : samlMessageDecoder.getBindingURI().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")).findAny().orElseThrow(() -> new RuntimeException(String.format("Only %s and %s are supported", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")));
    }

    public void sendAuthnResponse(SAMLPrincipal principal, HttpServletResponse response) throws MarshallingException, SignatureException, MessageEncodingException {
        Status status = SAMLBuilder.buildStatus((String)"urn:oasis:names:tc:SAML:2.0:status:Success");
        String entityId = this.idpConfiguration.getEntityId();
        Credential signingCredential = this.resolveCredential(entityId);
        Response authResponse = (Response)SAMLBuilder.buildSAMLObject(Response.class, (QName)Response.DEFAULT_ELEMENT_NAME);
        Issuer issuer = SAMLBuilder.buildIssuer((String)entityId);
        authResponse.setIssuer(issuer);
        authResponse.setID(UUID.randomUUID().toString());
        authResponse.setIssueInstant(new DateTime());
        authResponse.setInResponseTo(principal.getRequestID());
        Assertion assertion = SAMLBuilder.buildAssertion((SAMLPrincipal)principal, (Status)status, (String)entityId);
        SAMLBuilder.signAssertion((SignableXMLObject)assertion, (Credential)signingCredential);
        authResponse.getAssertions().add(assertion);
        authResponse.setDestination(principal.getAssertionConsumerServiceURL());
        authResponse.setStatus(status);
        Endpoint endpoint = (Endpoint)SAMLBuilder.buildSAMLObject(Endpoint.class, (QName)SingleSignOnService.DEFAULT_ELEMENT_NAME);
        endpoint.setLocation(principal.getAssertionConsumerServiceURL());
        HttpServletResponseAdapter outTransport = new HttpServletResponseAdapter(response, false);
        BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
        messageContext.setOutboundMessageTransport((OutTransport)outTransport);
        messageContext.setPeerEntityEndpoint(endpoint);
        messageContext.setOutboundSAMLMessage((SAMLObject)authResponse);
        messageContext.setOutboundSAMLMessageSigningCredential(signingCredential);
        messageContext.setOutboundMessageIssuer(entityId);
        messageContext.setRelayState(principal.getRelayState());
        this.encoder.encode((MessageContext)messageContext);
    }

    private Credential resolveCredential(String entityId) {
        try {
            return (Credential)this.keyManager.resolveSingle((Object)new CriteriaSet((Criteria)new EntityIDCriteria(entityId)));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

