/*
 * Decompiled with CFR 0.152.
 */
package mujina.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mujina.api.AuthenticationMethod;
import mujina.api.IdpConfiguration;
import mujina.api.SharedConfiguration;
import mujina.api.SharedController;
import mujina.api.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"}, consumes={"application/json"})
public class IdpController
extends SharedController {
    @Autowired
    public IdpController(IdpConfiguration configuration) {
        super((SharedConfiguration)configuration);
    }

    @PutMapping(value={"/attributes"})
    public void setAttributes(@RequestBody Map<String, List<String>> attributes) {
        this.LOG.debug("Request to replace all attributes {}", attributes);
        this.configuration().setAttributes(attributes);
    }

    @PutMapping(value={"/attributes/{name:.+}"})
    public void setAttribute(@PathVariable String name, @RequestBody List<String> values) {
        this.LOG.debug("Request to set attribute {} to {}", (Object)name, values);
        this.configuration().getAttributes().put(name, values);
    }

    @DeleteMapping(value={"/attributes/{name:.+}"})
    public void removeAttribute(@PathVariable String name) {
        this.LOG.debug("Request to remove attribute {}", (Object)name);
        this.configuration().getAttributes().remove(name);
    }

    @PutMapping(value={"/users"})
    public void addUser(@RequestBody User user) {
        this.LOG.debug("Request to add user {}", (Object)user);
        this.configuration().getUsers().add(new UsernamePasswordAuthenticationToken((Object)user.getName(), (Object)user.getPassword(), (Collection)user.getAuthorities().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList())));
    }

    @PutMapping(value={"authmethod"})
    public void setAuthenticationMethod(@RequestBody String authenticationMethod) {
        this.LOG.debug("Request to set auth method to {}", (Object)authenticationMethod);
        this.configuration().setAuthenticationMethod(AuthenticationMethod.valueOf((String)authenticationMethod));
    }

    @PutMapping(value={"/acsendpoint"})
    public void setAcsEndpoint(@RequestBody String acsEndpoint) {
        this.LOG.debug("Request to set Assertion Consumer Service Endpoint to {}", (Object)acsEndpoint);
        this.configuration().setAcsEndpoint(acsEndpoint);
    }

    private IdpConfiguration configuration() {
        return (IdpConfiguration)IdpConfiguration.class.cast(this.configuration);
    }
}

