/*
 * Decompiled with CFR 0.152.
 */
package mujina.idp;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import mujina.api.IdpConfiguration;
import mujina.idp.SAMLMessageHandler;
import mujina.saml.KeyStoreLocator;
import mujina.saml.UpgradedSAMLBootstrap;
import org.opensaml.common.binding.decoding.URIComparator;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.common.binding.security.IssueInstantRule;
import org.opensaml.common.binding.security.MessageReplayRule;
import org.opensaml.saml2.binding.decoding.HTTPPostDecoder;
import org.opensaml.saml2.binding.decoding.HTTPRedirectDeflateDecoder;
import org.opensaml.saml2.binding.encoding.HTTPPostSimpleSignEncoder;
import org.opensaml.util.storage.MapBasedStorageService;
import org.opensaml.util.storage.ReplayCache;
import org.opensaml.util.storage.StorageService;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.security.provider.BasicSecurityPolicy;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.saml.SAMLBootstrap;
import org.springframework.security.saml.key.JKSKeyManager;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.util.VelocityFactory;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableWebSecurity
public class WebSecurityConfigurer
extends WebMvcConfigurerAdapter {
    @Autowired
    private Environment environment;

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/login").setViewName("login");
    }

    @Bean
    @Autowired
    public SAMLMessageHandler samlMessageHandler(@Value(value="${idp.clock_skew}") int clockSkew, @Value(value="${idp.expires}") int expires, @Value(value="${idp.base_url}") String idpBaseUrl, @Value(value="${idp.compare_endpoints}") boolean compareEndpoints, IdpConfiguration idpConfiguration, JKSKeyManager keyManager) throws NoSuchAlgorithmException, CertificateException, InvalidKeySpecException, KeyStoreException, IOException, XMLStreamException, XMLParserException, URISyntaxException {
        StaticBasicParserPool parserPool = new StaticBasicParserPool();
        BasicSecurityPolicy securityPolicy = new BasicSecurityPolicy();
        securityPolicy.getPolicyRules().addAll(Arrays.asList(new IssueInstantRule(clockSkew, expires), new MessageReplayRule(new ReplayCache((StorageService)new MapBasedStorageService(), 14400000L))));
        HTTPRedirectDeflateDecoder httpRedirectDeflateDecoder = new HTTPRedirectDeflateDecoder((ParserPool)parserPool);
        HTTPPostDecoder httpPostDecoder = new HTTPPostDecoder((ParserPool)parserPool);
        if (!compareEndpoints) {
            URIComparator noopComparator = (uri1, uri2) -> true;
            httpPostDecoder.setURIComparator(noopComparator);
            httpRedirectDeflateDecoder.setURIComparator(noopComparator);
        }
        parserPool.initialize();
        HTTPPostSimpleSignEncoder httpPostSimpleSignEncoder = new HTTPPostSimpleSignEncoder(VelocityFactory.getEngine(), "/templates/saml2-post-simplesign-binding.vm", true);
        return new SAMLMessageHandler((KeyManager)keyManager, Arrays.asList(httpRedirectDeflateDecoder, httpPostDecoder), (SAMLMessageEncoder)httpPostSimpleSignEncoder, (SecurityPolicyResolver)new StaticSecurityPolicyResolver((SecurityPolicy)securityPolicy), idpConfiguration, idpBaseUrl);
    }

    @Bean
    public static SAMLBootstrap sAMLBootstrap() {
        return new UpgradedSAMLBootstrap();
    }

    @Autowired
    @Bean
    public JKSKeyManager keyManager(@Value(value="${idp.entity_id}") String idpEntityId, @Value(value="${idp.private_key}") String idpPrivateKey, @Value(value="${idp.certificate}") String idpCertificate, @Value(value="${idp.passphrase}") String idpPassphrase) throws InvalidKeySpecException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, XMLStreamException {
        KeyStore keyStore = KeyStoreLocator.createKeyStore((String)idpPassphrase);
        KeyStoreLocator.addPrivateKey((KeyStore)keyStore, (String)idpEntityId, (String)idpPrivateKey, (String)idpCertificate, (String)idpPassphrase);
        return new JKSKeyManager(keyStore, Collections.singletonMap(idpEntityId, idpPassphrase), idpEntityId);
    }

    @Bean
    public ServletContextInitializer servletContextInitializer() {
        return servletContext -> servletContext.getSessionCookieConfig().setName("mujinaIdpSessionId");
    }
}

