/*
 * Decompiled with CFR 0.152.
 */
package mujina.idp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class UserController {
    private List<Map<String, String>> samlAttributes;

    @Autowired
    public UserController(ObjectMapper objectMapper) throws IOException {
        this.samlAttributes = (List)objectMapper.readValue(new ClassPathResource("saml-attributes.json").getInputStream(), List.class);
    }

    @GetMapping(value={"/"})
    public String index(Authentication authentication) {
        return authentication == null ? "index" : "redirect:/user.html";
    }

    @GetMapping(value={"/user.html"})
    public String user(Authentication authentication, ModelMap modelMap) {
        modelMap.addAttribute("user", (Object)authentication);
        return "user";
    }

    @GetMapping(value={"/login"})
    public String login(ModelMap modelMap) {
        modelMap.addAttribute("samlAttributes", (Object)this.samlAttributes);
        return "login";
    }
}

