/*
 * Decompiled with CFR 0.152.
 */
package mujina.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mujina.api.AuthenticationMethod;
import mujina.api.SharedConfiguration;
import mujina.config.StandardAttributes;
import mujina.idp.FederatedUserAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.saml.key.JKSKeyManager;
import org.springframework.stereotype.Component;

@Component
public class IdpConfiguration
extends SharedConfiguration {
    private String defaultEntityId;
    private Map<String, List<String>> attributes = new TreeMap();
    private List<FederatedUserAuthenticationToken> users = new ArrayList();
    private String acsEndpoint;
    private AuthenticationMethod authenticationMethod;
    private AuthenticationMethod defaultAuthenticationMethod;
    private final String idpPrivateKey;
    private final String idpCertificate;
    private final StandardAttributes standardAttributes;

    @Autowired
    public IdpConfiguration(JKSKeyManager keyManager, @Value(value="${idp.entity_id}") String defaultEntityId, @Value(value="${idp.private_key}") String idpPrivateKey, @Value(value="${idp.certificate}") String idpCertificate, @Value(value="${idp.auth_method}") String authMethod, StandardAttributes standardAttributes) {
        super(keyManager);
        this.defaultEntityId = defaultEntityId;
        this.idpPrivateKey = idpPrivateKey;
        this.idpCertificate = idpCertificate;
        this.defaultAuthenticationMethod = AuthenticationMethod.valueOf((String)authMethod);
        this.standardAttributes = standardAttributes;
        this.reset();
    }

    public void reset() {
        this.setEntityId(this.defaultEntityId);
        this.resetAttributes();
        this.resetKeyStore(this.defaultEntityId, this.idpPrivateKey, this.idpCertificate);
        this.resetUsers();
        this.setAcsEndpoint(null);
        this.setAuthenticationMethod(this.defaultAuthenticationMethod);
        this.setSignatureAlgorithm(this.getDefaultSignatureAlgorithm());
    }

    private void resetUsers() {
        this.users.clear();
        this.users.addAll(Arrays.asList(new FederatedUserAuthenticationToken((Object)"admin", (Object)"secret", Arrays.asList(new SimpleGrantedAuthority("ROLE_USER"), new SimpleGrantedAuthority("ROLE_ADMIN"))), new FederatedUserAuthenticationToken((Object)"user", (Object)"secret", Arrays.asList(new SimpleGrantedAuthority("ROLE_USER")))));
    }

    private void resetAttributes() {
        Map configuredAttributes = this.standardAttributes.getAttributes();
        this.attributes.clear();
        for (Map.Entry attribute : configuredAttributes.entrySet()) {
            this.putAttribute((String)attribute.getKey(), new String[]{(String)attribute.getValue()});
        }
    }

    private void putAttribute(String key, String ... values) {
        this.attributes.put(key, Arrays.asList(values));
    }

    public String getDefaultEntityId() {
        return this.defaultEntityId;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public List<FederatedUserAuthenticationToken> getUsers() {
        return this.users;
    }

    public String getAcsEndpoint() {
        return this.acsEndpoint;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public AuthenticationMethod getDefaultAuthenticationMethod() {
        return this.defaultAuthenticationMethod;
    }

    public String getIdpPrivateKey() {
        return this.idpPrivateKey;
    }

    public String getIdpCertificate() {
        return this.idpCertificate;
    }

    public StandardAttributes getStandardAttributes() {
        return this.standardAttributes;
    }

    public void setDefaultEntityId(String defaultEntityId) {
        this.defaultEntityId = defaultEntityId;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public void setUsers(List<FederatedUserAuthenticationToken> users) {
        this.users = users;
    }

    public void setAcsEndpoint(String acsEndpoint) {
        this.acsEndpoint = acsEndpoint;
    }

    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public void setDefaultAuthenticationMethod(AuthenticationMethod defaultAuthenticationMethod) {
        this.defaultAuthenticationMethod = defaultAuthenticationMethod;
    }
}

