/*
 * Decompiled with CFR 0.152.
 */
package mujina.idp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mujina.api.IdpConfiguration;
import mujina.idp.FederatedUserAuthenticationToken;
import mujina.idp.SAMLMessageHandler;
import mujina.saml.SAMLAttribute;
import mujina.saml.SAMLPrincipal;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
public class SsoController {
    @Autowired
    private SAMLMessageHandler samlMessageHandler;
    @Autowired
    private IdpConfiguration idpConfiguration;

    @GetMapping(value={"/SingleSignOnService"})
    public void singleSignOnServiceGet(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, MarshallingException, SignatureException, MessageEncodingException, ValidationException, SecurityException, MessageDecodingException, MetadataProviderException, ServletException {
        this.doSSO(request, response, authentication, false);
    }

    @PostMapping(value={"/SingleSignOnService"})
    public void singleSignOnServicePost(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, MarshallingException, SignatureException, MessageEncodingException, ValidationException, SecurityException, MessageDecodingException, MetadataProviderException, ServletException {
        this.doSSO(request, response, authentication, true);
    }

    private void doSSO(HttpServletRequest request, HttpServletResponse response, Authentication authentication, boolean postRequest) throws ValidationException, SecurityException, MessageDecodingException, MarshallingException, SignatureException, MessageEncodingException, MetadataProviderException, IOException, ServletException {
        SAMLMessageContext messageContext = this.samlMessageHandler.extractSAMLMessageContext(request, response, postRequest);
        AuthnRequest authnRequest = (AuthnRequest)messageContext.getInboundSAMLMessage();
        String assertionConsumerServiceURL = this.idpConfiguration.getAcsEndpoint() != null ? this.idpConfiguration.getAcsEndpoint() : authnRequest.getAssertionConsumerServiceURL();
        List attributes = this.attributes(authentication);
        SAMLPrincipal principal = new SAMLPrincipal(authentication.getName(), attributes.stream().filter(attr -> "urn:oasis:names:tc:SAML:1.1:nameid-format".equals(attr.getName())).findFirst().map(attr -> attr.getValue()).orElse("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"), attributes, authnRequest.getIssuer().getValue(), authnRequest.getID(), assertionConsumerServiceURL, messageContext.getRelayState());
        this.samlMessageHandler.sendAuthnResponse(principal, response);
    }

    private List<SAMLAttribute> attributes(Authentication authentication) {
        String uid = authentication.getName();
        HashMap result = new HashMap(this.idpConfiguration.getAttributes());
        Optional<Map> optionalMap = this.idpConfiguration.getUsers().stream().filter(user -> user.getPrincipal().equals(uid)).findAny().map(FederatedUserAuthenticationToken::getAttributes);
        optionalMap.ifPresent(result::putAll);
        Map parameterMap = (Map)authentication.getDetails();
        parameterMap.forEach((key, values) -> result.put(key, Arrays.asList(values)));
        if (parameterMap.containsKey("persist-me") && "on".equalsIgnoreCase(((String[])parameterMap.get("persist-me"))[0])) {
            result.remove("persist-me");
            FederatedUserAuthenticationToken token = new FederatedUserAuthenticationToken((Object)uid, authentication.getCredentials(), Arrays.asList(new SimpleGrantedAuthority("ROLE_USER")));
            token.setAttributes(result);
            this.idpConfiguration.getUsers().removeIf(existingUser -> existingUser.getPrincipal().equals(uid));
            this.idpConfiguration.getUsers().add(token);
        }
        return result.entrySet().stream().filter(entry -> !((List)entry.getValue()).stream().allMatch(StringUtils::isEmpty)).map(entry -> ((String)entry.getKey()).equals("urn:mace:dir:attribute-def:uid") ? new SAMLAttribute((String)entry.getKey(), Collections.singletonList(uid)) : new SAMLAttribute((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }
}

