/*
 * Decompiled with CFR 0.152.
 */
package mujina.idp;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import mujina.api.IdpConfiguration;
import mujina.saml.SAMLBuilder;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@RestController
public class MetadataController {
    @Autowired
    private KeyManager keyManager;
    @Autowired
    private IdpConfiguration idpConfiguration;
    @Autowired
    Environment environment;

    @Autowired
    @RequestMapping(method={RequestMethod.GET}, value={"/metadata"}, produces={"application/xml"})
    public String metadata(@Value(value="${idp.base_url}") String idpBaseUrl) throws SecurityException, ParserConfigurationException, SignatureException, MarshallingException, TransformerException {
        EntityDescriptor entityDescriptor = (EntityDescriptor)SAMLBuilder.buildSAMLObject(EntityDescriptor.class, (QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        entityDescriptor.setEntityID(this.idpConfiguration.getEntityId());
        entityDescriptor.setID(SAMLBuilder.randomSAMLId());
        entityDescriptor.setValidUntil(new DateTime().plusMillis(86400000));
        Signature signature = (Signature)SAMLBuilder.buildSAMLObject(Signature.class, (QName)Signature.DEFAULT_ELEMENT_NAME);
        Credential credential = (Credential)this.keyManager.resolveSingle((Object)new CriteriaSet((Criteria)new EntityIDCriteria(this.idpConfiguration.getEntityId())));
        signature.setSigningCredential(credential);
        signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        Configuration.getMarshallerFactory().getMarshaller((XMLObject)entityDescriptor).marshall((XMLObject)entityDescriptor);
        IDPSSODescriptor idpssoDescriptor = (IDPSSODescriptor)SAMLBuilder.buildSAMLObject(IDPSSODescriptor.class, (QName)IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        NameIDFormat nameIDFormat = (NameIDFormat)SAMLBuilder.buildSAMLObject(NameIDFormat.class, (QName)NameIDFormat.DEFAULT_ELEMENT_NAME);
        nameIDFormat.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        idpssoDescriptor.getNameIDFormats().add(nameIDFormat);
        idpssoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        SingleSignOnService singleSignOnService = (SingleSignOnService)SAMLBuilder.buildSAMLObject(SingleSignOnService.class, (QName)SingleSignOnService.DEFAULT_ELEMENT_NAME);
        singleSignOnService.setLocation(idpBaseUrl + "/SingleSignOnService");
        singleSignOnService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        idpssoDescriptor.getSingleSignOnServices().add(singleSignOnService);
        X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
        keyInfoGeneratorFactory.setEmitEntityCertificate(true);
        KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
        KeyDescriptor encKeyDescriptor = (KeyDescriptor)SAMLBuilder.buildSAMLObject(KeyDescriptor.class, (QName)KeyDescriptor.DEFAULT_ELEMENT_NAME);
        encKeyDescriptor.setUse(UsageType.SIGNING);
        encKeyDescriptor.setKeyInfo(keyInfoGenerator.generate(credential));
        idpssoDescriptor.getKeyDescriptors().add(encKeyDescriptor);
        entityDescriptor.getRoleDescriptors().add(idpssoDescriptor);
        SAMLBuilder.signAssertion((SignableXMLObject)entityDescriptor, (Credential)credential);
        return this.writeEntityDescriptor(entityDescriptor);
    }

    private String writeEntityDescriptor(EntityDescriptor entityDescriptor) throws ParserConfigurationException, MarshallingException, TransformerException {
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)entityDescriptor);
        Element element = marshaller.marshall((XMLObject)entityDescriptor);
        return XMLHelper.nodeToString((Node)element);
    }
}

