/*
 * Decompiled with CFR 0.152.
 */
package mujina.idp;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class UserController {
    private final List<Map<String, String>> samlAttributes;

    @Autowired
    public UserController(ObjectMapper objectMapper, @Value(value="${idp.saml_attributes_config_file}") String samlAttributesConfigFile) throws IOException {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        this.samlAttributes = (List)objectMapper.readValue(loader.getResource(samlAttributesConfigFile).getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.samlAttributes.sort(Comparator.comparing(m -> (String)m.get("id")));
    }

    @GetMapping(value={"/"})
    public String index(Authentication authentication) {
        return authentication == null ? "index" : "redirect:/user.html";
    }

    @GetMapping(value={"/user.html"})
    public String user(Authentication authentication, ModelMap modelMap) {
        modelMap.addAttribute("user", (Object)authentication);
        return "user";
    }

    @GetMapping(value={"/login"})
    public String login(ModelMap modelMap) {
        modelMap.addAttribute("samlAttributes", (Object)this.samlAttributes);
        return "login";
    }
}

