/*
 * Decompiled with CFR 0.152.
 */
package mujina.idp;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mujina.idp.SAMLMessageHandler;
import org.opensaml.saml2.core.AuthnRequest;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.web.filter.OncePerRequestFilter;

public class ForceAuthnFilter
extends OncePerRequestFilter {
    private SAMLMessageHandler samlMessageHandler;

    public ForceAuthnFilter(SAMLMessageHandler samlMessageHandler) {
        this.samlMessageHandler = samlMessageHandler;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        SAMLMessageContext messageContext;
        String servletPath = request.getServletPath();
        if (servletPath == null || !servletPath.endsWith("SingleSignOnService") || request.getMethod().equalsIgnoreCase("GET")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            messageContext = this.samlMessageHandler.extractSAMLMessageContext(request, response, request.getMethod().equalsIgnoreCase("POST"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        AuthnRequest authnRequest = (AuthnRequest)messageContext.getInboundSAMLMessage();
        if (authnRequest.isForceAuthn().booleanValue()) {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

