/*
 * Decompiled with CFR 0.152.
 */
package mujina.sp;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.Filter;
import javax.xml.stream.XMLStreamException;
import mujina.saml.KeyStoreLocator;
import mujina.sp.DefaultMetadataDisplayFilter;
import mujina.sp.DefaultSAMLUserDetailsService;
import mujina.sp.ProxiedSAMLContextProviderLB;
import mujina.sp.ResourceMetadataProvider;
import mujina.sp.RoleSAMLAuthenticationProvider;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.SAMLProcessingFilter;
import org.springframework.security.saml.context.SAMLContextProviderImpl;
import org.springframework.security.saml.key.JKSKeyManager;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.CachingMetadataManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataDisplayFilter;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataGeneratorFilter;
import org.springframework.security.saml.parser.ParserPoolHolder;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;
import org.springframework.security.saml.util.VelocityFactory;
import org.springframework.security.saml.websso.WebSSOProfileOptions;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(securedEnabled=true)
public class WebSecurityConfigurer
extends WebSecurityConfigurerAdapter {
    @Value(value="${sp.idp_metadata_url}")
    private String identityProviderMetadataUrl;
    @Value(value="${sp.base_url}")
    private String spBaseUrl;
    @Value(value="${sp.entity_id}")
    private String spEntityId;
    @Value(value="${sp.private_key}")
    private String spPrivateKey;
    @Value(value="${sp.certificate}")
    private String spCertificate;
    @Value(value="${sp.passphrase}")
    private String spPassphrase;
    @Value(value="${sp.acs_location_path}")
    private String assertionConsumerServiceURLPath;
    private DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();

    @Bean
    public SAMLAuthenticationProvider samlAuthenticationProvider() {
        RoleSAMLAuthenticationProvider samlAuthenticationProvider = new RoleSAMLAuthenticationProvider();
        samlAuthenticationProvider.setUserDetails((SAMLUserDetailsService)new DefaultSAMLUserDetailsService());
        samlAuthenticationProvider.setForcePrincipalAsString(false);
        samlAuthenticationProvider.setExcludeCredential(true);
        return samlAuthenticationProvider;
    }

    @Bean
    public SAMLEntryPoint samlEntryPoint() {
        WebSSOProfileOptions webSSOProfileOptions = new WebSSOProfileOptions();
        webSSOProfileOptions.setIncludeScoping(Boolean.valueOf(false));
        SAMLEntryPoint samlEntryPoint = new SAMLEntryPoint();
        samlEntryPoint.setFilterProcessesUrl("login");
        samlEntryPoint.setDefaultProfileOptions(webSSOProfileOptions);
        return samlEntryPoint;
    }

    @Bean
    public ServletContextInitializer servletContextInitializer() {
        return servletContext -> servletContext.getSessionCookieConfig().setName("mujinaSpSessionId");
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/health", "/info"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/", "/metadata", "/favicon.ico", "/css.*", "/api/**", this.assertionConsumerServiceURLPath + "/**"})).permitAll().anyRequest()).hasRole("USER").and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.samlEntryPoint()).and()).csrf().disable()).addFilterBefore((Filter)this.metadataGeneratorFilter(), ChannelProcessingFilter.class).addFilterAfter((Filter)this.samlFilter(), BasicAuthenticationFilter.class).logout().logoutSuccessUrl("/");
    }

    @Bean
    public SavedRequestAwareAuthenticationSuccessHandler successRedirectHandler() {
        SavedRequestAwareAuthenticationSuccessHandler successRedirectHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        successRedirectHandler.setDefaultTargetUrl("/user");
        return successRedirectHandler;
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.samlAuthenticationProvider());
    }

    @Bean
    public MetadataDisplayFilter metadataDisplayFilter() {
        DefaultMetadataDisplayFilter displayFilter = new DefaultMetadataDisplayFilter();
        displayFilter.setFilterProcessesUrl("metadata");
        return displayFilter;
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler authenticationFailureHandler() {
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setUseForward(true);
        failureHandler.setDefaultFailureUrl("/error");
        return failureHandler;
    }

    @Bean
    public SAMLProcessingFilter samlWebSSOProcessingFilter() throws Exception {
        SAMLProcessingFilter samlWebSSOProcessingFilter = new SAMLProcessingFilter();
        samlWebSSOProcessingFilter.setFilterProcessesUrl("saml/SSO");
        samlWebSSOProcessingFilter.setAuthenticationManager(this.authenticationManager());
        samlWebSSOProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successRedirectHandler());
        samlWebSSOProcessingFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.authenticationFailureHandler());
        return samlWebSSOProcessingFilter;
    }

    @Bean
    public MetadataGeneratorFilter metadataGeneratorFilter() throws InvalidKeySpecException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, XMLStreamException {
        return new MetadataGeneratorFilter(this.metadataGenerator());
    }

    @Bean
    public FilterChainProxy samlFilter() throws Exception {
        ArrayList<DefaultSecurityFilterChain> chains = new ArrayList<DefaultSecurityFilterChain>();
        chains.add(this.chain("/login/**", (Filter)this.samlEntryPoint()));
        chains.add(this.chain("/metadata/**", (Filter)this.metadataDisplayFilter()));
        chains.add(this.chain(this.assertionConsumerServiceURLPath + "/**", (Filter)this.samlWebSSOProcessingFilter()));
        return new FilterChainProxy(chains);
    }

    private DefaultSecurityFilterChain chain(String pattern, Filter entryPoint) {
        return new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher(pattern), new Filter[]{entryPoint});
    }

    @Bean
    public ExtendedMetadata extendedMetadata() {
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setIdpDiscoveryEnabled(false);
        extendedMetadata.setSignMetadata(true);
        return extendedMetadata;
    }

    @Bean
    public MetadataProvider identityProvider() throws MetadataProviderException, XMLParserException {
        Resource resource = this.defaultResourceLoader.getResource(this.identityProviderMetadataUrl);
        ResourceMetadataProvider resourceMetadataProvider = new ResourceMetadataProvider(resource);
        resourceMetadataProvider.setParserPool(this.parserPool());
        ExtendedMetadataDelegate extendedMetadataDelegate = new ExtendedMetadataDelegate((MetadataProvider)resourceMetadataProvider, this.extendedMetadata());
        extendedMetadataDelegate.setMetadataTrustCheck(true);
        extendedMetadataDelegate.setMetadataRequireSignature(true);
        return extendedMetadataDelegate;
    }

    @Bean
    @Qualifier(value="metadata")
    public CachingMetadataManager metadata() throws MetadataProviderException, XMLParserException {
        ArrayList<MetadataProvider> providers = new ArrayList<MetadataProvider>();
        providers.add(this.identityProvider());
        return new CachingMetadataManager(providers);
    }

    @Bean
    public VelocityEngine velocityEngine() {
        return VelocityFactory.getEngine();
    }

    @Bean(initMethod="initialize")
    public ParserPool parserPool() {
        return new StaticBasicParserPool();
    }

    @Bean(name={"parserPoolHolder"})
    public ParserPoolHolder parserPoolHolder() {
        return new ParserPoolHolder();
    }

    @Bean
    public SAMLContextProviderImpl contextProvider() throws URISyntaxException {
        return new ProxiedSAMLContextProviderLB(new URI(this.spBaseUrl));
    }

    @Bean
    public MetadataGenerator metadataGenerator() throws NoSuchAlgorithmException, CertificateException, InvalidKeySpecException, KeyStoreException, IOException, XMLStreamException {
        MetadataGenerator metadataGenerator = new MetadataGenerator();
        metadataGenerator.setEntityId(this.spEntityId);
        metadataGenerator.setEntityBaseURL(this.spBaseUrl);
        metadataGenerator.setExtendedMetadata(this.extendedMetadata());
        metadataGenerator.setIncludeDiscoveryExtension(false);
        metadataGenerator.setKeyManager((KeyManager)this.keyManager());
        return metadataGenerator;
    }

    @Bean
    public JKSKeyManager keyManager() throws InvalidKeySpecException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, XMLStreamException {
        KeyStore keyStore = KeyStoreLocator.createKeyStore((String)this.spPassphrase);
        KeyStoreLocator.addPrivateKey((KeyStore)keyStore, (String)this.spEntityId, (String)this.spPrivateKey, (String)this.spCertificate, (String)this.spPassphrase);
        return new JKSKeyManager(keyStore, Collections.singletonMap(this.spEntityId, this.spPassphrase), this.spEntityId);
    }
}

