/*
 * Decompiled with CFR 0.152.
 */
package mujina.sp;

import java.util.ArrayList;
import mujina.api.SpConfiguration;
import mujina.sp.ConfigurableSAMLProcessor;
import mujina.sp.SAMLConfig;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.saml2.binding.decoding.HTTPPostDecoder;
import org.opensaml.saml2.binding.encoding.HTTPPostEncoder;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.xml.parse.ParserPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.saml.SAMLBootstrap;
import org.springframework.security.saml.log.SAMLDefaultLogger;
import org.springframework.security.saml.processor.HTTPArtifactBinding;
import org.springframework.security.saml.processor.HTTPPAOS11Binding;
import org.springframework.security.saml.processor.HTTPPostBinding;
import org.springframework.security.saml.processor.HTTPRedirectDeflateBinding;
import org.springframework.security.saml.processor.HTTPSOAP11Binding;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.websso.ArtifactResolutionProfile;
import org.springframework.security.saml.websso.ArtifactResolutionProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.security.saml.websso.WebSSOProfileConsumerHoKImpl;
import org.springframework.security.saml.websso.WebSSOProfileConsumerImpl;
import org.springframework.security.saml.websso.WebSSOProfileECPImpl;
import org.springframework.security.saml.websso.WebSSOProfileImpl;

@Configuration
public class SAMLConfig {
    @Autowired
    private Environment environment;

    @Bean
    public MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager() {
        return new MultiThreadedHttpConnectionManager();
    }

    @Bean
    public HttpClient httpClient() {
        return new HttpClient((HttpConnectionManager)this.multiThreadedHttpConnectionManager());
    }

    private HTTPArtifactBinding artifactBinding(ParserPool parserPool, VelocityEngine velocityEngine, ArtifactResolutionProfile artifactResolutionProfile) {
        return new HTTPArtifactBinding(parserPool, velocityEngine, artifactResolutionProfile);
    }

    @Bean
    @Autowired
    public HTTPSOAP11Binding soapBinding(ParserPool parserPool) {
        return new HTTPSOAP11Binding(parserPool);
    }

    @Bean
    @Autowired
    public HTTPPostBinding httpPostBinding(ParserPool parserPool, VelocityEngine velocityEngine, @Value(value="${sp.compare_endpoints}") boolean compareEndpoints) {
        HTTPPostEncoder encoder = new HTTPPostEncoder(velocityEngine, "/templates/saml2-post-binding.vm");
        HTTPPostDecoder decoder = new HTTPPostDecoder(parserPool);
        if (!compareEndpoints) {
            decoder.setURIComparator((uri1, uri2) -> true);
        }
        return new HTTPPostBinding(parserPool, (MessageDecoder)decoder, (MessageEncoder)encoder);
    }

    @Bean
    @Autowired
    public HTTPRedirectDeflateBinding httpRedirectDeflateBinding(ParserPool parserPool) {
        return new HTTPRedirectDeflateBinding(parserPool);
    }

    @Bean
    @Autowired
    public HTTPSOAP11Binding httpSOAP11Binding(ParserPool parserPool) {
        return new HTTPSOAP11Binding(parserPool);
    }

    @Bean
    @Autowired
    public HTTPPAOS11Binding httpPAOS11Binding(ParserPool parserPool) {
        return new HTTPPAOS11Binding(parserPool);
    }

    @Autowired
    @Bean
    public SAMLProcessor processor(VelocityEngine velocityEngine, ParserPool parserPool, SpConfiguration spConfiguration, @Value(value="${sp.compare_endpoints}") boolean compareEndpoints) {
        ArtifactResolutionProfileImpl artifactResolutionProfile = new ArtifactResolutionProfileImpl(this.httpClient());
        ArrayList<Object> bindings = new ArrayList<Object>();
        bindings.add(this.httpRedirectDeflateBinding(parserPool));
        bindings.add(this.httpPostBinding(parserPool, velocityEngine, compareEndpoints));
        bindings.add(this.artifactBinding(parserPool, velocityEngine, (ArtifactResolutionProfile)artifactResolutionProfile));
        bindings.add(this.httpSOAP11Binding(parserPool));
        bindings.add(this.httpPAOS11Binding(parserPool));
        return new ConfigurableSAMLProcessor(bindings, spConfiguration);
    }

    @Bean
    public static SAMLBootstrap sAMLBootstrap() {
        return new SAMLBootstrap();
    }

    @Bean
    public SAMLDefaultLogger samlLogger() {
        return new SAMLDefaultLogger();
    }

    @Bean
    public WebSSOProfileConsumer webSSOprofileConsumer() {
        1 webSSOProfileConsumer = this.environment.acceptsProfiles(new String[]{"test"}) ? new /* Unavailable Anonymous Inner Class!! */ : new WebSSOProfileConsumerImpl();
        webSSOProfileConsumer.setResponseSkew(900);
        return webSSOProfileConsumer;
    }

    @Bean
    public WebSSOProfileConsumerHoKImpl hokWebSSOprofileConsumer() {
        return new WebSSOProfileConsumerHoKImpl();
    }

    @Bean
    @Autowired
    public WebSSOProfile webSSOprofile(SAMLProcessor samlProcessor) {
        WebSSOProfileImpl webSSOProfile = new WebSSOProfileImpl();
        webSSOProfile.setProcessor(samlProcessor);
        return webSSOProfile;
    }

    @Bean
    public WebSSOProfileECPImpl ecpprofile() {
        return new WebSSOProfileECPImpl();
    }
}

