/*
 * Decompiled with CFR 0.152.
 */
package mujina.api;

import mujina.api.SharedConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.saml.key.JKSKeyManager;
import org.springframework.stereotype.Component;

@Component
public class SpConfiguration
extends SharedConfiguration {
    private String defaultEntityId;
    private String defaultIdpSSOServiceURL;
    private String idpSSOServiceURL;
    private String defaultProtocolBinding;
    private String protocolBinding;
    private String defaultAssertionConsumerServiceURL;
    private boolean defaultNeedsSigning;
    private String assertionConsumerServiceURL;
    private String spPrivateKey;
    private String spCertificate;

    @Autowired
    public SpConfiguration(JKSKeyManager keyManager, @Value(value="${sp.base_url}") String spBaseUrl, @Value(value="${sp.entity_id}") String defaultEntityId, @Value(value="${sp.single_sign_on_service_location}") String defaultIdpSSOServiceURL, @Value(value="${sp.acs_location_path}") String defaultAssertionConsumerServiceURLPath, @Value(value="${sp.protocol_binding}") String defaultProtocolBinding, @Value(value="${sp.private_key}") String spPrivateKey, @Value(value="${sp.certificate}") String spCertificate, @Value(value="${sp.needs_signing}") boolean needsSigning) {
        super(keyManager);
        this.setDefaultEntityId(defaultEntityId);
        this.setDefaultIdpSSOServiceURL(defaultIdpSSOServiceURL);
        this.setDefaultAssertionConsumerServiceURL(spBaseUrl + defaultAssertionConsumerServiceURLPath);
        this.setDefaultProtocolBinding(defaultProtocolBinding);
        this.setSpPrivateKey(spPrivateKey);
        this.setSpCertificate(spCertificate);
        this.setDefaultNeedsSigning(needsSigning);
        this.reset();
    }

    public void reset() {
        this.setEntityId(this.defaultEntityId, false);
        this.setNeedsSigning(this.defaultNeedsSigning);
        this.resetKeyStore(this.defaultEntityId, this.spPrivateKey, this.spCertificate);
        this.setIdpSSOServiceURL(this.defaultIdpSSOServiceURL);
        this.setProtocolBinding(this.defaultProtocolBinding);
        this.setAssertionConsumerServiceURL(this.defaultAssertionConsumerServiceURL);
        this.setSignatureAlgorithm(this.getDefaultSignatureAlgorithm());
    }

    public String getDefaultEntityId() {
        return this.defaultEntityId;
    }

    public String getDefaultIdpSSOServiceURL() {
        return this.defaultIdpSSOServiceURL;
    }

    public String getIdpSSOServiceURL() {
        return this.idpSSOServiceURL;
    }

    public String getDefaultProtocolBinding() {
        return this.defaultProtocolBinding;
    }

    public String getProtocolBinding() {
        return this.protocolBinding;
    }

    public String getDefaultAssertionConsumerServiceURL() {
        return this.defaultAssertionConsumerServiceURL;
    }

    public boolean isDefaultNeedsSigning() {
        return this.defaultNeedsSigning;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public String getSpPrivateKey() {
        return this.spPrivateKey;
    }

    public String getSpCertificate() {
        return this.spCertificate;
    }

    public void setDefaultEntityId(String defaultEntityId) {
        this.defaultEntityId = defaultEntityId;
    }

    public void setDefaultIdpSSOServiceURL(String defaultIdpSSOServiceURL) {
        this.defaultIdpSSOServiceURL = defaultIdpSSOServiceURL;
    }

    public void setIdpSSOServiceURL(String idpSSOServiceURL) {
        this.idpSSOServiceURL = idpSSOServiceURL;
    }

    public void setDefaultProtocolBinding(String defaultProtocolBinding) {
        this.defaultProtocolBinding = defaultProtocolBinding;
    }

    public void setProtocolBinding(String protocolBinding) {
        this.protocolBinding = protocolBinding;
    }

    public void setDefaultAssertionConsumerServiceURL(String defaultAssertionConsumerServiceURL) {
        this.defaultAssertionConsumerServiceURL = defaultAssertionConsumerServiceURL;
    }

    public void setDefaultNeedsSigning(boolean defaultNeedsSigning) {
        this.defaultNeedsSigning = defaultNeedsSigning;
    }

    public void setAssertionConsumerServiceURL(String assertionConsumerServiceURL) {
        this.assertionConsumerServiceURL = assertionConsumerServiceURL;
    }

    public void setSpPrivateKey(String spPrivateKey) {
        this.spPrivateKey = spPrivateKey;
    }

    public void setSpCertificate(String spCertificate) {
        this.spCertificate = spCertificate;
    }
}

