/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import myconext.exceptions.ExpiredAuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@RestController
public class JsonErrorController
implements ErrorController {
    private static final Logger LOG = LoggerFactory.getLogger(JsonErrorController.class);
    private final ErrorAttributes errorAttributes;
    private final String redirectUrl;

    @Autowired
    public JsonErrorController(ErrorAttributes errorAttributes, @Value(value="${idp_redirect_url}") String redirectUrl) {
        this.errorAttributes = errorAttributes;
        this.redirectUrl = redirectUrl;
    }

    public String getErrorPath() {
        return "/error";
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity error(HttpServletRequest request) {
        HttpStatus statusCode;
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, false);
        Throwable error = this.errorAttributes.getError((WebRequest)webRequest);
        if (error == null) {
            statusCode = result.containsKey("status") ? HttpStatus.valueOf((int)((Integer)result.get("status"))) : HttpStatus.INTERNAL_SERVER_ERROR;
        } else {
            if (error instanceof ExpiredAuthenticationException) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).header("Location", new String[]{this.redirectUrl + "/expired"})).build();
            }
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class);
            statusCode = annotation != null ? annotation.value() : HttpStatus.BAD_REQUEST;
        }
        result.remove("message");
        result.put("status", statusCode.value());
        return ResponseEntity.status((HttpStatus)statusCode).body((Object)result);
    }
}

