/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import myconext.exceptions.DuplicateUserEmailException;
import myconext.exceptions.ExpiredAuthenticationException;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.UserNotFoundException;
import myconext.mail.MailBox;
import myconext.model.MagicLinkRequest;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.UpdateUserSecurityRequest;
import myconext.model.User;
import myconext.model.UserResponse;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.UserRepository;
import myconext.validation.EmailValidator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/myconext/api"})
public class UserController {
    private UserRepository userRepository;
    private AuthenticationRequestRepository authenticationRequestRepository;
    private MailBox mailBox;
    private String magicLinkUrl;
    private SecureRandom random = new SecureRandom();
    private PasswordEncoder passwordEncoder = new BCryptPasswordEncoder(-1, this.random);
    private EmailValidator emailValidator = new EmailValidator();

    public UserController(UserRepository userRepository, AuthenticationRequestRepository authenticationRequestRepository, MailBox mailBox, @Value(value="${email.magic-link-url}") String magicLinkUrl) {
        this.userRepository = userRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.mailBox = mailBox;
        this.magicLinkUrl = magicLinkUrl;
    }

    @PostMapping(value={"/idp/magic_link_request"})
    public ResponseEntity newMagicLinkRequest(@Valid @RequestBody MagicLinkRequest magicLinkRequest) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(magicLinkRequest.getAuthenticationRequestId()).orElseThrow(ExpiredAuthenticationException::new);
        User user = magicLinkRequest.getUser();
        Optional userByEmail = this.userRepository.findUserByEmail(user.getEmail());
        if (userByEmail.isPresent()) {
            throw new DuplicateUserEmailException();
        }
        this.emailValidator.validEmail(user.getEmail());
        User userToSave = new User(user.getEmail(), user.getGivenName(), user.getFamilyName());
        userToSave.encryptPassword(user.getPassword(), this.passwordEncoder);
        userToSave = (User)this.userRepository.save((Object)userToSave);
        return this.doMagicLink(userToSave, samlAuthenticationRequest, magicLinkRequest, false);
    }

    @PutMapping(value={"/idp/magic_link_request"})
    public ResponseEntity magicLinkRequest(HttpServletResponse response, @Valid @RequestBody MagicLinkRequest magicLinkRequest) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(magicLinkRequest.getAuthenticationRequestId()).orElseThrow(ExpiredAuthenticationException::new);
        User providedUser = magicLinkRequest.getUser();
        User user = (User)this.userRepository.findUserByEmail(providedUser.getEmail()).orElseThrow(UserNotFoundException::new);
        if (magicLinkRequest.isUsePassword()) {
            if (!this.passwordEncoder.matches((CharSequence)providedUser.getPassword(), user.getPassword())) {
                throw new ForbiddenException();
            }
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        return this.doMagicLink(user, samlAuthenticationRequest, magicLinkRequest, magicLinkRequest.isUsePassword());
    }

    @GetMapping(value={"/sp/me"})
    public ResponseEntity me(Authentication authentication) {
        User user = this.userRepository.findOneUserByEmail(((User)authentication.getPrincipal()).getEmail());
        return ResponseEntity.ok((Object)new UserResponse(user));
    }

    @PutMapping(value={"/sp/update"})
    public ResponseEntity updateUserProfile(Authentication authentication, @RequestBody User deltaUser) {
        User user = this.verifyAndFetchUser(authentication, deltaUser);
        user.setFamilyName(deltaUser.getFamilyName());
        user.setGivenName(deltaUser.getGivenName());
        user.validate();
        this.userRepository.save((Object)user);
        return ResponseEntity.status((int)201).body((Object)new UserResponse(user));
    }

    @PutMapping(value={"/sp/security"})
    public ResponseEntity updateUserSecurity(Authentication authentication, @RequestBody UpdateUserSecurityRequest updateUserRequest) {
        User deltaUser = (User)this.userRepository.findById((Object)updateUserRequest.getUserId()).orElseThrow(UserNotFoundException::new);
        User user = this.verifyAndFetchUser(authentication, deltaUser);
        if (StringUtils.hasText((String)user.getPassword()) && !this.passwordEncoder.matches((CharSequence)updateUserRequest.getCurrentPassword(), user.getPassword())) {
            throw new ForbiddenException();
        }
        user.encryptPassword(updateUserRequest.getNewPassword(), this.passwordEncoder);
        this.userRepository.save((Object)user);
        return ResponseEntity.status((int)201).body((Object)new UserResponse(user));
    }

    @DeleteMapping(value={"/sp/delete"})
    public ResponseEntity deleteUser(Authentication authentication, @Valid @RequestBody User deltaUser) {
        User user = this.verifyAndFetchUser(authentication, deltaUser);
        this.userRepository.delete((Object)user);
        return ResponseEntity.status((int)201).build();
    }

    private User verifyAndFetchUser(Authentication authentication, User deltaUser) {
        User principal = (User)authentication.getPrincipal();
        if (!principal.getId().equals(deltaUser.getId())) {
            throw new ForbiddenException();
        }
        return this.userRepository.findOneUserByEmail(principal.getEmail());
    }

    private ResponseEntity doMagicLink(User user, SamlAuthenticationRequest samlAuthenticationRequest, MagicLinkRequest magicLinkRequest, boolean passwordFlow) {
        samlAuthenticationRequest.setHash(this.hash());
        samlAuthenticationRequest.setUserId(user.getId());
        samlAuthenticationRequest.setRememberMe(magicLinkRequest.isRememberMe());
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        if (passwordFlow) {
            return ResponseEntity.status((int)201).body(Collections.singletonMap("url", this.magicLinkUrl + "?h=" + samlAuthenticationRequest.getHash()));
        }
        if (user.isNewUser()) {
            this.mailBox.sendAccountVerification(user, samlAuthenticationRequest.getHash());
        } else {
            this.mailBox.sendMagicLink(user, samlAuthenticationRequest.getHash(), samlAuthenticationRequest.getRequesterEntityId());
        }
        return ResponseEntity.status((int)201).body(Collections.singletonMap("result", "ok"));
    }

    private String hash() {
        byte[] bytes = new byte[64];
        this.random.nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }
}

