/*
 * Decompiled with CFR 0.152.
 */
package myconext.mail;

import myconext.mail.MailBox;
import myconext.mail.MockMailBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration
@EnableConfigurationProperties(value={MailProperties.class})
public class MailConfiguration {
    @Value(value="${email.from}")
    private String emailFrom;
    @Value(value="${email.magic-link-url}")
    private String magicLinkUrl;
    @Value(value="${email.my-surfconext-url}")
    private String mySURFconextURL;
    @Autowired
    private JavaMailSender mailSender;

    @Bean
    @Profile(value={"!dev"})
    public MailBox mailSenderProd() {
        return new MailBox(this.mailSender, this.emailFrom, this.magicLinkUrl, this.mySURFconextURL);
    }

    @Bean
    @Profile(value={"dev", "test"})
    @Primary
    public MailBox mailSenderDev(Environment environment) {
        return new MockMailBox(this.mailSender, this.emailFrom, this.magicLinkUrl, this.mySURFconextURL, environment);
    }
}

