/*
 * Decompiled with CFR 0.152.
 */
package myconext.repository;

import java.util.Date;
import java.util.Optional;
import myconext.exceptions.ExpiredAuthenticationException;
import myconext.model.SamlAuthenticationRequest;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface AuthenticationRequestRepository
extends MongoRepository<SamlAuthenticationRequest, String> {
    public Long deleteByExpiresInBeforeAndRememberMe(Date var1, boolean var2);

    public Optional<SamlAuthenticationRequest> findByHash(String var1);

    default public Optional<SamlAuthenticationRequest> findByIdAndNotExpired(String id) {
        Optional authenticationRequestOptional = this.findById((Object)id);
        authenticationRequestOptional.ifPresent(req -> {
            if (req.isExpired() && !req.isRememberMe()) {
                throw new ExpiredAuthenticationException();
            }
        });
        return authenticationRequestOptional;
    }
}

