/*
 * Decompiled with CFR 0.152.
 */
package myconext.shibboleth;

import java.io.UnsupportedEncodingException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import myconext.model.User;
import myconext.repository.UserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);
    public static final String SHIB_GIVEN_NAME = "Shib-givenName";
    public static final String SHIB_SUR_NAME = "Shib-surName";
    public static final String SHIB_EMAIL = "Shib-InetOrgPerson-mail";
    private final UserRepository userRepository;

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, UserRepository userRepository) {
        this.setAuthenticationManager(authenticationManager);
        this.userRepository = userRepository;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String givenName = this.getHeader(SHIB_GIVEN_NAME, request);
        String familyName = this.getHeader(SHIB_SUR_NAME, request);
        String email = this.getHeader(SHIB_EMAIL, request);
        if (StringUtils.isEmpty((Object)givenName) || StringUtils.isEmpty((Object)familyName) || StringUtils.isEmpty((Object)email)) {
            LOG.warn("Missing required attribute(s): givenName {} familyName {} email {}", new Object[]{givenName, familyName, email});
            return null;
        }
        Optional optionalUser = this.userRepository.findUserByEmail(email);
        return optionalUser.orElseGet(() -> this.provisionUser(givenName, familyName, email));
    }

    private User provisionUser(String givenName, String familyName, String email) {
        User user = new User(email, givenName, familyName);
        LOG.info("Provision new User: givenName {} familyName {} email {}", new Object[]{givenName, familyName, email});
        return (User)this.userRepository.save((Object)user);
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private String getHeader(String name, HttpServletRequest request) {
        String header = request.getHeader(name);
        try {
            return StringUtils.hasText((String)header) ? new String(header.getBytes("ISO8859-1"), "UTF-8") : header;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

