/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import java.util.Date;
import myconext.model.SamlAuthenticationRequest;
import myconext.repository.AuthenticationRequestRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ResourceCleaner {
    private static final Log LOG = LogFactory.getLog(ResourceCleaner.class);
    private AuthenticationRequestRepository authenticationRequestRepository;
    private boolean cronJobResponsible;

    @Autowired
    public ResourceCleaner(AuthenticationRequestRepository authenticationRequestRepository, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible) {
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.cronJobResponsible = cronJobResponsible;
    }

    @Scheduled(cron="${cron.token-cleaner-expression}")
    public void clean() {
        if (!this.cronJobResponsible) {
            return;
        }
        Date now = new Date();
        this.info(SamlAuthenticationRequest.class, this.authenticationRequestRepository.deleteByExpiresInBeforeAndRememberMe(now, false).longValue());
    }

    private void info(Class clazz, long count) {
        LOG.info((Object)String.format("Deleted %s instances of %s in cleanup", count, clazz));
    }
}

