/*
 * Decompiled with CFR 0.152.
 */
package myconext.config;

import javax.servlet.Filter;
import myconext.config.NoopFilter;
import myconext.mail.MailBox;
import myconext.manage.ServiceNameResolver;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.UserRepository;
import myconext.saml.ImmutableSamlConfigurationRepository;
import myconext.security.GuestIdpAuthenticationRequestFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.saml.SamlMessageStore;
import org.springframework.security.saml.provider.SamlServerConfiguration;
import org.springframework.security.saml.provider.config.SamlConfigurationRepository;
import org.springframework.security.saml.provider.identity.config.SamlIdentityProviderServerBeanConfiguration;

@Configuration
public class BeanConfig
extends SamlIdentityProviderServerBeanConfiguration {
    private final String redirectUrl;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final UserRepository userRepository;
    private final String spEntityId;
    private final int rememberMeMaxAge;
    private final boolean secureCookie;
    private final String magicLinkUrl;
    private final MailBox mailBox;
    private final ServiceNameResolver serviceNameResolver;
    private ImmutableSamlConfigurationRepository immutableSamlConfigurationRepository;

    public BeanConfig(@Value(value="${base_path}") String basePath, @Value(value="${idp_redirect_url}") String redirectUrl, @Value(value="${sp_entity_id}") String spEntityId, @Value(value="${remember_me_max_age_seconds}") int rememberMeMaxAge, @Value(value="${secure_cookie}") boolean secureCookie, @Value(value="${email.magic-link-url}") String magicLinkUrl, AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, MailBox mailBox, ServiceNameResolver serviceNameResolver) {
        this.immutableSamlConfigurationRepository = new ImmutableSamlConfigurationRepository(basePath);
        this.redirectUrl = redirectUrl;
        this.spEntityId = spEntityId;
        this.rememberMeMaxAge = rememberMeMaxAge;
        this.secureCookie = secureCookie;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.magicLinkUrl = magicLinkUrl;
        this.mailBox = mailBox;
        this.serviceNameResolver = serviceNameResolver;
    }

    protected SamlServerConfiguration getDefaultHostSamlServerConfiguration() {
        return new SamlServerConfiguration();
    }

    public Filter idpAuthnRequestFilter() {
        return new GuestIdpAuthenticationRequestFilter(this.getSamlProvisioning(), (SamlMessageStore)this.samlAssertionStore(), this.redirectUrl, this.serviceNameResolver, this.authenticationRequestRepository, this.userRepository, this.spEntityId, this.rememberMeMaxAge, this.secureCookie, this.magicLinkUrl, this.mailBox);
    }

    public Filter samlConfigurationFilter(SamlServerConfiguration serverConfig) {
        this.immutableSamlConfigurationRepository.setConfiguration(serverConfig);
        return new NoopFilter();
    }

    public SamlConfigurationRepository samlConfigurationRepository() {
        return this.immutableSamlConfigurationRepository;
    }
}

