/*
 * Decompiled with CFR 0.152.
 */
package myconext.manage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ServiceNameResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceNameResolver.class);
    private final Resource metaDataResource;
    private final ObjectMapper objectMapper;
    private Map<String, Map<String, String>> serviceNames = new HashMap();

    @Autowired
    public ServiceNameResolver(@Value(value="${metadata_sp_url}") Resource metaDataResource, ObjectMapper objectMapper) {
        this(metaDataResource, objectMapper, true);
    }

    ServiceNameResolver(@Value(value="${metadata_sp_url}") Resource metaDataResource, ObjectMapper objectMapper, boolean lazy) {
        this.metaDataResource = metaDataResource;
        this.objectMapper = objectMapper;
        if (!lazy) {
            this.refresh();
        }
    }

    @Scheduled(initialDelay=0L, fixedRate=3600000L)
    public void refresh() {
        long start = System.currentTimeMillis();
        try {
            this.serviceNames = ((List)this.objectMapper.readValue(this.metaDataResource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).stream().collect(Collectors.toMap(m -> (String)m.keySet().iterator().next(), m -> (Map)m.values().iterator().next()));
            LOG.info("Refreshed all " + this.serviceNames.size() + " Service names from " + this.metaDataResource + "in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Throwable t) {
            LOG.error("Error in refreshing service names from " + this.metaDataResource, t);
        }
    }

    public String resolve(String entityId) {
        Map names = this.serviceNames.getOrDefault(entityId, Collections.emptyMap());
        String name = names.getOrDefault("en", (String)names.get("nl"));
        return StringUtils.hasText((String)name) ? name : entityId;
    }
}

