/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LoginController {
    private static final Log LOG = LogFactory.getLog(LoginController.class);
    private boolean secureCookie;
    private final Map<String, String> config = new HashMap();

    public LoginController(@Value(value="${base_path}") String basePath, @Value(value="${base_domain}") String baseDomain, @Value(value="${my_conext_url}") String myConextUrl, @Value(value="${onegini_entity_id}") String oneGiniEntityId, @Value(value="${guest_idp_entity_id}") String guestIdpEntityId, @Value(value="${email.magic-link-url}") String magicLinkUrl, @Value(value="${domain}") String domain, @Value(value="${secure_cookie}") boolean secureCookie, @Value(value="${idp_redirect_url}") String idpBaseUrl) {
        this.config.put("loginUrl", basePath + "/login");
        this.config.put("baseDomain", baseDomain);
        this.config.put("migrationUrl", String.format("%s/Shibboleth.sso/Login?entityID=%s&target=/migration", myConextUrl, oneGiniEntityId));
        this.config.put("magicLinkUrl", magicLinkUrl);
        this.config.put("eduIDLoginUrl", String.format("%s/Shibboleth.sso/Login?entityID=%s", myConextUrl, guestIdpEntityId));
        this.config.put("eduIDRegisterUrl", String.format("%s/register", idpBaseUrl));
        this.config.put("domain", domain);
        this.secureCookie = secureCookie;
    }

    @GetMapping(value={"/register"})
    public void register(@RequestParam(value="lang", required=false, defaultValue="en") String lang, @RequestParam(value="location", required=false) String location, HttpServletResponse response) throws IOException {
        response.setHeader("Set-Cookie", "REGISTER_MODUS=true; SameSite=Lax" + (this.secureCookie ? "; Secure" : ""));
        String redirectLocation = StringUtils.hasText((String)location) ? location : (String)this.config.get("eduIDLoginUrl") + "&lang=" + lang;
        response.sendRedirect(redirectLocation);
    }

    @GetMapping(value={"/config"})
    public Map<String, String> config() {
        return this.config;
    }
}

